/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.utils.StringUtils;

public class TypeDefinition
implements Serializable {
    private String id;
    private String type;
    @SerializedName(value="items")
    private List<TypeDefinition> items;
    @SerializedName(value="enum")
    private List<String> enums;
    private String $ref;
    private Map<String, TypeDefinition> properties;
    private String typeBuilderName;

    public TypeDefinition() {
    }

    public TypeDefinition(String type) {
        this.setType(type);
    }

    public static String[] formatTypes(String[] types) {
        String[] newTypes = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            newTypes[i] = TypeDefinition.formatType(types[i]);
        }
        return newTypes;
    }

    public static String formatType(String type) {
        if (TypeDefinition.isGenericType(type)) {
            return TypeDefinition.formatGenericType(type);
        }
        return type;
    }

    private static String formatGenericType(String type) {
        return StringUtils.replace((String)type, (String)", ", (String)",");
    }

    private static boolean isGenericType(String type) {
        return type.contains("<") && type.contains(">");
    }

    public String get$ref() {
        return this.$ref;
    }

    public List<String> getEnums() {
        if (this.enums == null) {
            this.enums = new ArrayList<String>();
        }
        return this.enums;
    }

    public String getId() {
        return this.id;
    }

    public List<TypeDefinition> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<TypeDefinition>();
        }
        return this.items;
    }

    public Map<String, TypeDefinition> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, TypeDefinition>();
        }
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeBuilderName() {
        return this.typeBuilderName;
    }

    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    public void setEnums(List<String> enums) {
        this.enums = enums;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setItems(List<TypeDefinition> items) {
        this.items = items;
    }

    public void setProperties(Map<String, TypeDefinition> properties) {
        this.properties = properties;
    }

    public void setType(String type) {
        this.type = TypeDefinition.formatType(type);
    }

    public void setTypeBuilderName(String typeBuilderName) {
        this.typeBuilderName = typeBuilderName;
    }

    public String toString() {
        return "TypeDefinition [id=" + this.id + ", type=" + this.type + ", properties=" + this.properties + ", $ref=" + this.$ref + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getItems(), that.getItems()) && Objects.equals(this.getEnums(), that.getEnums()) && Objects.equals(this.get$ref(), that.get$ref()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getType(), this.getItems(), this.getEnums(), this.get$ref(), this.getProperties());
    }
}

