/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.kubernetes;

import com.google.gson.Gson;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.kubernetes.MeshConstant;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshAppRuleListener;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshEnvListener;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class KubernetesMeshEnvListener
implements MeshEnvListener {
    public static final Logger logger = LoggerFactory.getLogger(KubernetesMeshEnvListener.class);
    private static volatile boolean usingApiServer = false;
    private static volatile KubernetesClient kubernetesClient;
    private static volatile String namespace;
    private final Map<String, MeshAppRuleListener> appRuleListenerMap = new ConcurrentHashMap<String, MeshAppRuleListener>();
    private final Map<String, Watch> vsAppWatch = new ConcurrentHashMap<String, Watch>();
    private final Map<String, Watch> drAppWatch = new ConcurrentHashMap<String, Watch>();
    private final Map<String, String> vsAppCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> drAppCache = new ConcurrentHashMap<String, String>();

    public static void injectKubernetesEnv(KubernetesClient client, String configuredNamespace) {
        usingApiServer = true;
        kubernetesClient = client;
        namespace = configuredNamespace;
    }

    public boolean isEnable() {
        return usingApiServer;
    }

    public void onSubscribe(String appName, MeshAppRuleListener listener) {
        this.appRuleListenerMap.put(appName, listener);
        logger.info("Subscribe Mesh Rule in Kubernetes. AppName: " + appName);
        this.subscribeVs(appName);
        this.subscribeDr(appName);
        this.notifyOnce(appName);
    }

    private void subscribeVs(final String appName) {
        if (this.vsAppWatch.containsKey(appName)) {
            return;
        }
        try {
            Watch watch = kubernetesClient.customResource(MeshConstant.getVsDefinition()).watch(namespace, appName, null, new ListOptionsBuilder().build(), (Watcher)new Watcher<String>(){

                public void eventReceived(Watcher.Action action, String resource) {
                    logger.info("Received VS Rule notification. AppName: " + appName + " Action:" + action + " Resource:" + resource);
                    if (action == Watcher.Action.ADDED || action == Watcher.Action.MODIFIED) {
                        Map drRuleMap = (Map)new Gson().fromJson(resource, Map.class);
                        String vsRule = new Yaml((BaseConstructor)new SafeConstructor()).dump((Object)drRuleMap);
                        KubernetesMeshEnvListener.this.vsAppCache.put(appName, vsRule);
                        if (KubernetesMeshEnvListener.this.drAppCache.containsKey(appName)) {
                            KubernetesMeshEnvListener.this.notifyListener(vsRule, appName, (String)KubernetesMeshEnvListener.this.drAppCache.get(appName));
                        }
                    } else {
                        ((MeshAppRuleListener)KubernetesMeshEnvListener.this.appRuleListenerMap.get(appName)).receiveConfigInfo("");
                    }
                }

                public void onClose(WatcherException cause) {
                }
            });
            this.vsAppWatch.put(appName, watch);
            try {
                Map vsRule = kubernetesClient.customResource(MeshConstant.getVsDefinition()).get(namespace, appName);
                this.vsAppCache.put(appName, new Yaml((BaseConstructor)new SafeConstructor()).dump((Object)vsRule));
            }
            catch (Throwable throwable) {}
        }
        catch (IOException e) {
            logger.error("Error occurred when listen kubernetes crd.", (Throwable)e);
        }
    }

    private void notifyListener(String vsRule, String appName, String drRule) {
        String rule = vsRule + "\n---\n" + drRule;
        logger.info("Notify App Rule Listener. AppName: " + appName + " Rule:" + rule);
        this.appRuleListenerMap.get(appName).receiveConfigInfo(rule);
    }

    private void subscribeDr(final String appName) {
        if (this.drAppWatch.containsKey(appName)) {
            return;
        }
        try {
            Watch watch = kubernetesClient.customResource(MeshConstant.getDrDefinition()).watch(namespace, appName, null, new ListOptionsBuilder().build(), (Watcher)new Watcher<String>(){

                public void eventReceived(Watcher.Action action, String resource) {
                    logger.info("Received VS Rule notification. AppName: " + appName + " Action:" + action + " Resource:" + resource);
                    if (action == Watcher.Action.ADDED || action == Watcher.Action.MODIFIED) {
                        Map drRuleMap = (Map)new Gson().fromJson(resource, Map.class);
                        String drRule = new Yaml((BaseConstructor)new SafeConstructor()).dump((Object)drRuleMap);
                        KubernetesMeshEnvListener.this.drAppCache.put(appName, drRule);
                        if (KubernetesMeshEnvListener.this.vsAppCache.containsKey(appName)) {
                            KubernetesMeshEnvListener.this.notifyListener((String)KubernetesMeshEnvListener.this.vsAppCache.get(appName), appName, drRule);
                        }
                    } else {
                        ((MeshAppRuleListener)KubernetesMeshEnvListener.this.appRuleListenerMap.get(appName)).receiveConfigInfo("");
                    }
                }

                public void onClose(WatcherException cause) {
                }
            });
            this.drAppWatch.put(appName, watch);
            try {
                Map drRule = kubernetesClient.customResource(MeshConstant.getDrDefinition()).get(namespace, appName);
                this.drAppCache.put(appName, new Yaml((BaseConstructor)new SafeConstructor()).dump((Object)drRule));
            }
            catch (Throwable throwable) {}
        }
        catch (IOException e) {
            logger.error("Error occurred when listen kubernetes crd.", (Throwable)e);
        }
    }

    private void notifyOnce(String appName) {
        if (this.vsAppCache.containsKey(appName) && this.drAppCache.containsKey(appName)) {
            this.notifyListener(this.vsAppCache.get(appName), appName, this.drAppCache.get(appName));
        }
    }

    public void onUnSubscribe(String appName) {
        this.appRuleListenerMap.remove(appName);
        if (this.vsAppWatch.containsKey(appName)) {
            this.vsAppWatch.remove(appName).close();
        }
        this.vsAppCache.remove(appName);
        if (this.drAppWatch.containsKey(appName)) {
            this.drAppWatch.remove(appName).close();
        }
        this.drAppCache.remove(appName);
    }
}

