/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.validation.filter;

import javax.validation.ValidationException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.validation.Validation;
import org.apache.dubbo.validation.Validator;

@Activate(group={"consumer", "provider"}, value={"validation"}, order=10000)
public class ValidationFilter
implements Filter {
    private Validation validation;

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.validation != null && !invocation.getMethodName().startsWith("$") && ConfigUtils.isNotEmpty((String)invoker.getUrl().getMethodParameter(invocation.getMethodName(), "validation"))) {
            try {
                Validator validator = this.validation.getValidator(invoker.getUrl());
                if (validator != null) {
                    validator.validate(invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments());
                }
            }
            catch (RpcException e) {
                throw e;
            }
            catch (ValidationException e) {
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)new ValidationException(e.getMessage()), (Invocation)invocation);
            }
            catch (Throwable t) {
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)t, (Invocation)invocation);
            }
        }
        return invoker.invoke(invocation);
    }
}

