/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.configcenter.support.zookeeper.ZookeeperDataListener;

public class CacheListener {
    private Map<String, ZookeeperDataListener> pathKeyListeners = new ConcurrentHashMap<String, ZookeeperDataListener>();

    public ZookeeperDataListener addListener(String pathKey, ConfigurationListener configurationListener, String key, String group) {
        ZookeeperDataListener zookeeperDataListener = this.pathKeyListeners.computeIfAbsent(pathKey, _pathKey -> new ZookeeperDataListener((String)_pathKey, key, group));
        zookeeperDataListener.addListener(configurationListener);
        return zookeeperDataListener;
    }

    public ZookeeperDataListener removeListener(String pathKey, ConfigurationListener configurationListener) {
        ZookeeperDataListener zookeeperDataListener = this.pathKeyListeners.get(pathKey);
        if (zookeeperDataListener != null) {
            zookeeperDataListener.removeListener(configurationListener);
            if (CollectionUtils.isEmpty(zookeeperDataListener.getListeners())) {
                this.pathKeyListeners.remove(pathKey);
            }
        }
        return zookeeperDataListener;
    }

    public ZookeeperDataListener getCachedListener(String pathKey) {
        return this.pathKeyListeners.get(pathKey);
    }

    public Map<String, ZookeeperDataListener> getPathKeyListeners() {
        return this.pathKeyListeners;
    }

    public void clear() {
        this.pathKeyListeners.clear();
    }
}

