/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperDynamicConfiguration.class);
    private Executor executor;
    private String rootPath;
    private final ZookeeperClient zkClient;
    private CountDownLatch initializedLatch;
    private CacheListener cacheListener;
    private URL url;

    ZookeeperDynamicConfiguration(URL url, ZookeeperTransporter zookeeperTransporter) {
        this.url = url;
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/config";
        this.initializedLatch = new CountDownLatch(1);
        this.cacheListener = new CacheListener(this.rootPath, this.initializedLatch);
        this.executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory(this.getClass().getSimpleName(), true));
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addDataListener(this.rootPath, (DataListener)this.cacheListener, this.executor);
        try {
            long timeout = url.getParameter("init.timeout", 5000);
            boolean isCountDown = this.initializedLatch.await(timeout, TimeUnit.MILLISECONDS);
            if (!isCountDown) {
                throw new IllegalStateException("Failed to receive INITIALIZED event from zookeeper, pls. check if url " + url + " is correct");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failed to build local cache for config center (zookeeper)." + url);
        }
    }

    public Object getInternalProperty(String key) {
        return this.zkClient.getContent(key);
    }

    public void addListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.addListener(this.getPathKey(group, key), listener);
    }

    public void removeListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.removeListener(this.getPathKey(group, key), listener);
    }

    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.getInternalProperty(this.getPathKey(group, key));
    }

    public boolean publishConfig(String key, String group, String content) {
        String path = this.getPathKey(group, key);
        this.zkClient.create(path, content, false);
        return true;
    }

    public SortedSet<String> getConfigKeys(String group) {
        String path = this.getPathKey(group, "");
        List nodes = this.zkClient.getChildren(path);
        return CollectionUtils.isEmpty((Collection)nodes) ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet(nodes));
    }

    private String buildPath(String group) {
        String actualGroup = StringUtils.isEmpty((String)group) ? "dubbo" : group;
        return this.rootPath + "/" + actualGroup;
    }

    private String getPathKey(String group, String key) {
        if (StringUtils.isEmpty((String)key)) {
            return this.buildPath(group);
        }
        return this.buildPath(group) + "/" + key;
    }
}

