/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperDynamicConfiguration.class);
    private Executor executor;
    private CuratorFramework client;
    private String rootPath;
    private TreeCache treeCache;
    private CountDownLatch initializedLatch;
    private CacheListener cacheListener;
    private URL url;

    ZookeeperDynamicConfiguration(URL url) {
        this.url = url;
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/config";
        ExponentialBackoffRetry policy = new ExponentialBackoffRetry(1000, 3);
        int sessionTimeout = url.getParameter("config.session.timeout", 60000);
        int connectTimeout = url.getParameter("config.connect.timeout", 10000);
        String connectString = url.getBackupAddress();
        this.client = CuratorFrameworkFactory.newClient((String)connectString, (int)sessionTimeout, (int)connectTimeout, (RetryPolicy)policy);
        this.client.start();
        try {
            boolean connected = this.client.blockUntilConnected(3 * connectTimeout, TimeUnit.MILLISECONDS);
            if (!connected) {
                if (url.getParameter("config.check", true)) {
                    throw new IllegalStateException("Failed to connect to config center (zookeeper): " + connectString + " in " + 3 * connectTimeout + "ms.");
                }
                logger.warn("The config center (zookeeper) is not fully initialized in " + 3 * connectTimeout + "ms, address is: " + connectString);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("The thread was interrupted unexpectedly when trying connecting to zookeeper " + connectString + " config center, ", e);
        }
        this.initializedLatch = new CountDownLatch(1);
        this.cacheListener = new CacheListener(this.rootPath, this.initializedLatch);
        this.executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory(this.getClass().getSimpleName(), true));
        try {
            this.buildCache();
        }
        catch (Exception e) {
            logger.warn("Failed to build local cache for config center (zookeeper), address is ." + connectString);
        }
    }

    public Object getInternalProperty(String key) {
        ChildData childData = this.treeCache.getCurrentData(key);
        if (childData != null) {
            return new String(childData.getData(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public void addListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.addListener(key, listener);
    }

    public void removeListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.removeListener(key, listener);
    }

    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isNotEmpty((String)group)) {
            key = group + "/" + key;
        } else {
            int i = key.lastIndexOf(".");
            key = key.substring(0, i) + "/" + key.substring(i + 1);
        }
        return (String)this.getInternalProperty(this.rootPath + "/" + key);
    }

    private void buildCache() throws Exception {
        this.treeCache = new TreeCache(this.client, this.rootPath);
        this.treeCache.getListenable().addListener((Object)this.cacheListener, this.executor);
        this.treeCache.start();
        this.initializedLatch.await();
    }
}

