/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigChangeEvent;
import org.apache.dubbo.configcenter.ConfigChangeType;
import org.apache.dubbo.configcenter.ConfigurationListener;

public class CacheListener
implements TreeCacheListener {
    private Map<String, Set<ConfigurationListener>> keyListeners = new ConcurrentHashMap<String, Set<ConfigurationListener>>();
    private CountDownLatch initializedLatch;
    private String rootPath;

    public CacheListener(String rootPath, CountDownLatch initializedLatch) {
        this.rootPath = rootPath;
        this.initializedLatch = initializedLatch;
    }

    public void childEvent(CuratorFramework aClient, TreeCacheEvent event) throws Exception {
        TreeCacheEvent.Type type = event.getType();
        ChildData data = event.getData();
        if (type == TreeCacheEvent.Type.INITIALIZED) {
            this.initializedLatch.countDown();
            return;
        }
        if (data == null) {
            return;
        }
        if (data.getPath().split("/").length >= 5) {
            ConfigChangeType changeType;
            byte[] value = data.getData();
            String key = this.pathToKey(data.getPath());
            switch (type) {
                case NODE_ADDED: {
                    changeType = ConfigChangeType.ADDED;
                    break;
                }
                case NODE_REMOVED: {
                    changeType = ConfigChangeType.DELETED;
                    break;
                }
                case NODE_UPDATED: {
                    changeType = ConfigChangeType.MODIFIED;
                    break;
                }
                default: {
                    return;
                }
            }
            ConfigChangeEvent configChangeEvent = new ConfigChangeEvent(key, new String(value, StandardCharsets.UTF_8), changeType);
            Set<ConfigurationListener> listeners = this.keyListeners.get(key);
            if (CollectionUtils.isNotEmpty(listeners)) {
                listeners.forEach(listener -> listener.process(configChangeEvent));
            }
        }
    }

    public void addListener(String key, ConfigurationListener configurationListener) {
        Set listeners = this.keyListeners.computeIfAbsent(key, k -> new CopyOnWriteArraySet());
        listeners.add(configurationListener);
    }

    public void removeListener(String key, ConfigurationListener configurationListener) {
        Set<ConfigurationListener> listeners = this.keyListeners.get(key);
        if (listeners != null) {
            listeners.remove(configurationListener);
        }
    }

    private String pathToKey(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return path;
        }
        return path.replace(this.rootPath + "/", "").replaceAll("/", ".");
    }
}

