/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring6.beans.factory.aot;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.dubbo.config.spring6.beans.factory.aot.AutowiredElementResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.aot.AutowiredArguments;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.ThrowingConsumer;

public final class ReferencedMethodArgumentsResolver
extends AutowiredElementResolver {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final boolean required;
    @Nullable
    private final String[] shortcuts;

    private ReferencedMethodArgumentsResolver(String methodName, Class<?>[] parameterTypes, boolean required, @Nullable String[] shortcuts) {
        Assert.hasText((String)methodName, (String)"'methodName' must not be empty");
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.required = required;
        this.shortcuts = shortcuts;
    }

    public static ReferencedMethodArgumentsResolver forMethod(String methodName, Class<?> ... parameterTypes) {
        return new ReferencedMethodArgumentsResolver(methodName, parameterTypes, false, null);
    }

    public static ReferencedMethodArgumentsResolver forRequiredMethod(String methodName, Class<?> ... parameterTypes) {
        return new ReferencedMethodArgumentsResolver(methodName, parameterTypes, true, null);
    }

    public ReferencedMethodArgumentsResolver withShortcut(String ... beanNames) {
        return new ReferencedMethodArgumentsResolver(this.methodName, this.parameterTypes, this.required, beanNames);
    }

    public void resolve(RegisteredBean registeredBean, ThrowingConsumer<AutowiredArguments> action) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        Assert.notNull(action, (String)"'action' must not be null");
        AutowiredArguments resolved = this.resolve(registeredBean);
        if (resolved != null) {
            action.accept((Object)resolved);
        }
    }

    @Nullable
    public AutowiredArguments resolve(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        return this.resolveArguments(registeredBean, this.getMethod(registeredBean));
    }

    public void resolveAndInvoke(RegisteredBean registeredBean, Object instance) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        Assert.notNull((Object)instance, (String)"'instance' must not be null");
        Method method = this.getMethod(registeredBean);
        AutowiredArguments resolved = this.resolveArguments(registeredBean, method);
        if (resolved != null) {
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])resolved.toArray());
        }
    }

    @Nullable
    private AutowiredArguments resolveArguments(RegisteredBean registeredBean, Method method) {
        String beanName = registeredBean.getBeanName();
        Class beanClass = registeredBean.getBeanClass();
        ConfigurableListableBeanFactory beanFactory = registeredBean.getBeanFactory();
        Assert.isInstanceOf(AutowireCapableBeanFactory.class, (Object)beanFactory);
        AutowireCapableBeanFactory autowireCapableBeanFactory = (AutowireCapableBeanFactory)beanFactory;
        int argumentCount = method.getParameterCount();
        Object[] arguments = new Object[argumentCount];
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(argumentCount);
        TypeConverter typeConverter = beanFactory.getTypeConverter();
        for (int i = 0; i < argumentCount; ++i) {
            String shortcut;
            MethodParameter parameter = new MethodParameter(method, i);
            DependencyDescriptor descriptor = new DependencyDescriptor(parameter, this.required);
            descriptor.setContainingClass(beanClass);
            String string = shortcut = this.shortcuts != null ? this.shortcuts[i] : null;
            if (shortcut != null) {
                descriptor = new AutowiredElementResolver.ShortcutDependencyDescriptor(descriptor, shortcut, parameter.getParameterType());
            }
            try {
                Object injectedArgument = beanFactory.getBean(shortcut);
                Object argument = autowireCapableBeanFactory.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
                arguments[i] = injectedArgument;
                continue;
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(null, beanName, new InjectionPoint(parameter), ex);
            }
        }
        this.registerDependentBeans((ConfigurableBeanFactory)beanFactory, beanName, autowiredBeanNames);
        return AutowiredArguments.of((Object[])arguments);
    }

    private Method getMethod(RegisteredBean registeredBean) {
        Method method = ReflectionUtils.findMethod((Class)registeredBean.getBeanClass(), (String)this.methodName, (Class[])this.parameterTypes);
        Assert.notNull((Object)method, () -> "Method '" + this.methodName + "' with parameter types [" + this.toCommaSeparatedNames(this.parameterTypes) + "] declared on " + registeredBean.getBeanClass().getName() + " could not be found.");
        return method;
    }

    private String toCommaSeparatedNames(Class<?> ... parameterTypes) {
        return Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", "));
    }
}

