/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.status;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.Status;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.springframework.context.ApplicationContext;

@Activate
public class DataSourceStatusChecker
implements StatusChecker {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceStatusChecker.class);

    public Status check() {
        Optional<ApplicationContext> context = SpringExtensionFactory.getContexts().stream().filter(Objects::nonNull).findFirst();
        if (!context.isPresent()) {
            return new Status(Status.Level.UNKNOWN);
        }
        Map dataSources = context.get().getBeansOfType(DataSource.class, false, false);
        if (CollectionUtils.isEmptyMap((Map)dataSources)) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : dataSources.entrySet()) {
            DataSource dataSource = (DataSource)entry.getValue();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append((String)entry.getKey());
            try {
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    try (ResultSet resultSet = metaData.getTypeInfo();){
                        if (!resultSet.next()) {
                            level = Status.Level.ERROR;
                        }
                    }
                    buf.append(metaData.getURL());
                    buf.append("(");
                    buf.append(metaData.getDatabaseProductName());
                    buf.append("-");
                    buf.append(metaData.getDatabaseProductVersion());
                    buf.append(")");
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                return new Status(level, e.getMessage());
            }
        }
        return new Status(level, buf.toString());
    }
}

