/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.constants.RegisterTypeEnum;
import org.apache.dubbo.common.deploy.AbstractDeployer;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.DeployListener;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployListener;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.config.deploy.DefaultApplicationDeployer;
import org.apache.dubbo.config.utils.SimpleReferenceCache;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class DefaultModuleDeployer
extends AbstractDeployer<ModuleModel>
implements ModuleDeployer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultModuleDeployer.class);
    private final List<CompletableFuture<?>> asyncExportingFutures = new ArrayList();
    private final List<CompletableFuture<?>> asyncReferringFutures = new ArrayList();
    private final List<ServiceConfigBase<?>> exportedServices = new ArrayList();
    private final ModuleModel moduleModel;
    private final FrameworkExecutorRepository frameworkExecutorRepository;
    private final ExecutorRepository executorRepository;
    private final ModuleConfigManager configManager;
    private final SimpleReferenceCache referenceCache;
    private final ApplicationDeployer applicationDeployer;
    private CompletableFuture startFuture;
    private Boolean background;
    private Boolean exportAsync;
    private Boolean referAsync;
    private boolean registryInteracted;
    private CompletableFuture<?> exportFuture;
    private CompletableFuture<?> referFuture;

    public DefaultModuleDeployer(ModuleModel moduleModel) {
        super((ScopeModel)moduleModel);
        this.moduleModel = moduleModel;
        this.configManager = moduleModel.getConfigManager();
        this.frameworkExecutorRepository = (FrameworkExecutorRepository)moduleModel.getApplicationModel().getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
        this.executorRepository = ExecutorRepository.getInstance((ApplicationModel)moduleModel.getApplicationModel());
        this.referenceCache = SimpleReferenceCache.newCache();
        this.applicationDeployer = DefaultApplicationDeployer.get((ScopeModel)moduleModel);
        Set listeners = moduleModel.getExtensionLoader(ModuleDeployListener.class).getSupportedExtensionInstances();
        for (ModuleDeployListener listener : listeners) {
            this.addDeployListener((DeployListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IllegalStateException {
        if (this.initialized) {
            return;
        }
        DefaultModuleDeployer defaultModuleDeployer = this;
        synchronized (defaultModuleDeployer) {
            if (this.initialized) {
                return;
            }
            this.onInitialize();
            this.loadConfigs();
            ModuleConfig moduleConfig = (ModuleConfig)this.moduleModel.getConfigManager().getModule().orElseThrow(() -> new IllegalStateException("Default module config is not initialized"));
            this.exportAsync = Boolean.TRUE.equals(moduleConfig.getExportAsync());
            this.referAsync = Boolean.TRUE.equals(moduleConfig.getReferAsync());
            this.background = moduleConfig.getBackground();
            if (this.background == null) {
                this.background = this.isExportBackground() || this.isReferBackground();
            }
            this.initialized = true;
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has been initialized!");
            }
        }
    }

    public Future start() throws IllegalStateException {
        this.applicationDeployer.initialize();
        return this.startSync();
    }

    private synchronized Future startSync() throws IllegalStateException {
        if (this.isStopping() || this.isStopped() || this.isFailed()) {
            throw new IllegalStateException(this.getIdentifier() + " is stopping or stopped, can not start again");
        }
        try {
            if (this.isStarting() || this.isStarted() || this.isCompletion()) {
                return this.startFuture;
            }
            this.onModuleStarting();
            this.initialize();
            this.exportServices();
            if (this.moduleModel != this.moduleModel.getApplicationModel().getInternalModule()) {
                this.applicationDeployer.prepareInternalModule();
            }
            this.referServices();
            if (this.asyncExportingFutures.isEmpty() && this.asyncReferringFutures.isEmpty()) {
                this.onModuleStarted();
                this.registerServices();
                this.checkReferences();
                this.onModuleCompletion();
                this.completeStartFuture(true);
            } else {
                this.frameworkExecutorRepository.getSharedExecutor().submit(() -> {
                    try {
                        this.waitExportFinish();
                        this.waitReferFinish();
                        this.onModuleStarted();
                        this.registerServices();
                        this.checkReferences();
                        this.onModuleCompletion();
                    }
                    catch (Throwable e) {
                        logger.warn("5-23", "", "", "wait for export/refer services occurred an exception", e);
                        this.onModuleFailed(this.getIdentifier() + " start failed: " + e, e);
                    }
                    finally {
                        this.completeStartFuture(true);
                    }
                });
            }
        }
        catch (Throwable e) {
            this.onModuleFailed(this.getIdentifier() + " start failed: " + e, e);
            throw e;
        }
        return this.startFuture;
    }

    public Future getStartFuture() {
        return this.startFuture;
    }

    private boolean hasExportedServices() {
        return !this.configManager.getServices().isEmpty();
    }

    public void stop() throws IllegalStateException {
        this.moduleModel.destroy();
    }

    public void preDestroy() throws IllegalStateException {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        this.onModuleStopping();
        this.offline();
    }

    private void offline() {
        try {
            ModuleServiceRepository serviceRepository = this.moduleModel.getServiceRepository();
            List exportedServices = serviceRepository.getExportedServices();
            for (ProviderModel exportedService : exportedServices) {
                List statedUrls = exportedService.getStatedUrl();
                for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                    if (!statedURL.isRegistered()) continue;
                    this.doOffline(statedURL);
                }
            }
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Exceptions occurred when unregister services.", t);
        }
    }

    private void doOffline(ProviderModel.RegisterStatedURL statedURL) {
        RegistryFactory registryFactory = (RegistryFactory)statedURL.getRegistryUrl().getOrDefaultApplicationModel().getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
        Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
        registry.unregister(statedURL.getProviderUrl());
        statedURL.setRegistered(false);
    }

    public synchronized void postDestroy() throws IllegalStateException {
        if (this.isStopped()) {
            return;
        }
        this.unexportServices();
        this.unreferServices();
        ModuleServiceRepository serviceRepository = this.moduleModel.getServiceRepository();
        if (serviceRepository != null) {
            List consumerModels = serviceRepository.getReferredServices();
            for (ConsumerModel consumerModel : consumerModels) {
                try {
                    if (consumerModel.getDestroyRunner() == null) continue;
                    consumerModel.getDestroyRunner().run();
                }
                catch (Throwable t) {
                    logger.error("5-13", "there are problems with the custom implementation.", "", "Unable to destroy model: consumerModel.", t);
                }
            }
            List exportedServices = serviceRepository.getExportedServices();
            for (ProviderModel providerModel : exportedServices) {
                try {
                    if (providerModel.getDestroyRunner() == null) continue;
                    providerModel.getDestroyRunner().run();
                }
                catch (Throwable t) {
                    logger.error("5-13", "there are problems with the custom implementation.", "", "Unable to destroy model: providerModel.", t);
                }
            }
            serviceRepository.destroy();
        }
        this.onModuleStopped();
    }

    private void onInitialize() {
        for (DeployListener listener : this.listeners) {
            try {
                listener.onInitialize((ScopeModel)this.moduleModel);
            }
            catch (Throwable e) {
                logger.error("5-14", "", "", this.getIdentifier() + " an exception occurred when handle initialize event", e);
            }
        }
    }

    private void onModuleStarting() {
        this.setStarting();
        this.startFuture = new CompletableFuture();
        logger.info(this.getIdentifier() + " is starting.");
        this.applicationDeployer.notifyModuleChanged(this.moduleModel, DeployState.STARTING);
    }

    private void onModuleStarted() {
        if (this.isStarting()) {
            this.setStarted();
            logger.info(this.getIdentifier() + " has started.");
            this.applicationDeployer.notifyModuleChanged(this.moduleModel, DeployState.STARTED);
        }
    }

    private void onModuleCompletion() {
        if (this.isStarted()) {
            this.setCompletion();
            logger.info(this.getIdentifier() + " has completed.");
            this.applicationDeployer.notifyModuleChanged(this.moduleModel, DeployState.COMPLETION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onModuleFailed(String msg, Throwable ex) {
        try {
            try {
                this.unexportServices();
            }
            catch (Throwable t) {
                logger.info("Failed to un-export services after module failed.", t);
            }
            this.setFailed(ex);
            logger.error("5-14", "", "", "Model start failed: " + msg, ex);
            this.applicationDeployer.notifyModuleChanged(this.moduleModel, DeployState.FAILED);
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void completeStartFuture(boolean value) {
        if (this.startFuture != null && !this.startFuture.isDone()) {
            this.startFuture.complete(value);
        }
        if (this.exportFuture != null && !this.exportFuture.isDone()) {
            this.exportFuture.cancel(true);
        }
        if (this.referFuture != null && !this.referFuture.isDone()) {
            this.referFuture.cancel(true);
        }
    }

    private void onModuleStopping() {
        try {
            this.setStopping();
            logger.info(this.getIdentifier() + " is stopping.");
            this.applicationDeployer.notifyModuleChanged(this.moduleModel, DeployState.STOPPING);
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void onModuleStopped() {
        try {
            this.setStopped();
            logger.info(this.getIdentifier() + " has stopped.");
            this.applicationDeployer.notifyModuleChanged(this.moduleModel, DeployState.STOPPED);
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void loadConfigs() {
        this.moduleModel.getConfigManager().loadConfigs();
        this.moduleModel.getConfigManager().refreshAll();
    }

    private void exportServices() {
        for (ServiceConfigBase sc : this.configManager.getServices()) {
            this.exportServiceInternal(sc);
        }
    }

    private void registerServices() {
        for (ServiceConfigBase sc : this.configManager.getServices()) {
            if (Boolean.FALSE.equals(sc.isRegister())) continue;
            this.registerServiceInternal(sc);
        }
        this.applicationDeployer.refreshServiceInstance();
    }

    private void checkReferences() {
        Optional module = this.configManager.getModule();
        long timeout = module.map(ModuleConfig::getCheckReferenceTimeout).orElse(30000L);
        for (ReferenceConfigBase rc : this.configManager.getReferences()) {
            this.referenceCache.check(rc, timeout);
        }
    }

    private void exportServiceInternal(ServiceConfigBase sc) {
        ServiceConfig serviceConfig = (ServiceConfig)sc;
        if (!serviceConfig.isRefreshed()) {
            serviceConfig.refresh();
        }
        if (sc.isExported()) {
            return;
        }
        if (this.exportAsync.booleanValue() || sc.shouldExportAsync().booleanValue()) {
            ScheduledExecutorService executor = this.executorRepository.getServiceExportExecutor();
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    if (!sc.isExported()) {
                        sc.export();
                        this.exportedServices.add(sc);
                    }
                }
                catch (Throwable t) {
                    logger.error("5-9", "", "", "Failed to async export service config: " + this.getIdentifier() + " , catch error : " + t.getMessage(), t);
                }
            }, executor);
            this.asyncExportingFutures.add(future);
        } else if (!sc.isExported()) {
            sc.export(RegisterTypeEnum.AUTO_REGISTER_BY_DEPLOYER);
            this.exportedServices.add(sc);
        }
        if (serviceConfig.hasRegistrySpecified()) {
            this.registryInteracted = true;
        }
    }

    private void registerServiceInternal(ServiceConfigBase sc) {
        ServiceConfig serviceConfig = (ServiceConfig)sc;
        if (!serviceConfig.isRefreshed()) {
            serviceConfig.refresh();
        }
        if (!sc.isExported()) {
            return;
        }
        if (sc.shouldDelay()) {
            return;
        }
        sc.register(true);
    }

    private void unexportServices() {
        this.exportedServices.forEach(sc -> {
            try {
                this.configManager.removeConfig((AbstractConfig)sc);
                sc.unexport();
            }
            catch (Throwable t) {
                logger.info("Failed to un-export service. Service Key: " + sc.getUniqueServiceName(), t);
            }
        });
        this.exportedServices.clear();
        this.asyncExportingFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncExportingFutures.clear();
    }

    private void referServices() {
        this.configManager.getReferences().forEach(rc -> {
            try {
                ReferenceConfig referenceConfig = (ReferenceConfig)((Object)rc);
                if (!referenceConfig.isRefreshed()) {
                    referenceConfig.refresh();
                }
                if (rc.shouldInit()) {
                    if (this.referAsync.booleanValue() || rc.shouldReferAsync().booleanValue()) {
                        ExecutorService executor = this.executorRepository.getServiceReferExecutor();
                        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                            try {
                                this.referenceCache.get(rc, false);
                            }
                            catch (Throwable t) {
                                logger.error("5-9", "", "", "Failed to async export service config: " + this.getIdentifier() + " , catch error : " + t.getMessage(), t);
                            }
                        }, executor);
                        this.asyncReferringFutures.add(future);
                    } else {
                        this.referenceCache.get(rc, false);
                    }
                }
            }
            catch (Throwable t) {
                logger.error("5-15", "", "", "Model reference failed: " + this.getIdentifier() + " , catch error : " + t.getMessage(), t);
                this.referenceCache.destroy(rc);
                throw t;
            }
        });
    }

    private void unreferServices() {
        try {
            this.asyncReferringFutures.forEach(future -> {
                if (!future.isDone()) {
                    future.cancel(true);
                }
            });
            this.asyncReferringFutures.clear();
            this.referenceCache.destroyAll();
            for (ReferenceConfigBase rc : this.configManager.getReferences()) {
                rc.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitExportFinish() {
        try {
            logger.info(this.getIdentifier() + " waiting services exporting ...");
            this.exportFuture = CompletableFuture.allOf(this.asyncExportingFutures.toArray(new CompletableFuture[0]));
            this.exportFuture.get();
        }
        catch (Throwable e) {
            logger.warn("5-9", "", "", this.getIdentifier() + " export services occurred an exception: " + e.toString());
        }
        finally {
            logger.info(this.getIdentifier() + " export services finished.");
            this.asyncExportingFutures.clear();
        }
    }

    private void waitReferFinish() {
        try {
            logger.info(this.getIdentifier() + " waiting services referring ...");
            this.referFuture = CompletableFuture.allOf(this.asyncReferringFutures.toArray(new CompletableFuture[0]));
            this.referFuture.get();
        }
        catch (Throwable e) {
            logger.warn("5-24", "", "", this.getIdentifier() + " refer services occurred an exception: " + e.toString());
        }
        finally {
            logger.info(this.getIdentifier() + " refer services finished.");
            this.asyncReferringFutures.clear();
        }
    }

    public boolean isBackground() {
        return this.background;
    }

    private boolean isExportBackground() {
        return this.moduleModel.getConfigManager().getProviders().stream().map(ProviderConfig::getExportBackground).anyMatch(k -> k != null && k != false);
    }

    private boolean isReferBackground() {
        return this.moduleModel.getConfigManager().getConsumers().stream().map(ConsumerConfig::getReferBackground).anyMatch(k -> k != null && k != false);
    }

    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    public void prepare() {
        this.applicationDeployer.initialize();
        this.initialize();
    }

    public boolean hasRegistryInteraction() {
        return this.registryInteracted;
    }

    public ApplicationDeployer getApplicationDeployer() {
        return this.applicationDeployer;
    }
}

