/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import org.apache.dubbo.config.nested.TripleConfig;

public class TripleBuilder {
    private Integer maxBodySize;
    private Integer maxResponseBodySize;
    private Integer maxChunkSize;
    private Integer maxHeaderSize;
    private Integer maxInitialLineLength;
    private Integer initialBufferSize;
    private Integer headerTableSize;
    private Boolean enablePush;
    private Integer maxConcurrentStreams;
    private Integer initialWindowSize;
    private Integer maxFrameSize;
    private Integer maxHeaderListSize;

    public static TripleBuilder newBuilder() {
        return new TripleBuilder();
    }

    public TripleBuilder maxBodySize(Integer maxBodySize) {
        this.maxBodySize = maxBodySize;
        return this.getThis();
    }

    public TripleBuilder maxResponseBodySize(Integer maxResponseBodySize) {
        this.maxResponseBodySize = maxResponseBodySize;
        return this.getThis();
    }

    public TripleBuilder maxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this.getThis();
    }

    public TripleBuilder maxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this.getThis();
    }

    public TripleBuilder maxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this.getThis();
    }

    public TripleBuilder initialBufferSize(Integer initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
        return this.getThis();
    }

    public TripleBuilder headerTableSize(Integer headerTableSize) {
        this.headerTableSize = headerTableSize;
        return this.getThis();
    }

    public TripleBuilder enablePush(Boolean enablePush) {
        this.enablePush = enablePush;
        return this.getThis();
    }

    public TripleBuilder maxConcurrentStreams(Integer maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
        return this.getThis();
    }

    public TripleBuilder initialWindowSize(Integer initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
        return this.getThis();
    }

    public TripleBuilder maxFrameSize(Integer maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this.getThis();
    }

    public TripleBuilder maxHeaderListSize(Integer maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
        return this.getThis();
    }

    protected TripleBuilder getThis() {
        return this;
    }

    public TripleConfig build() {
        TripleConfig triple = new TripleConfig();
        if (this.maxBodySize != null) {
            triple.setMaxBodySize(this.maxBodySize);
        }
        if (this.maxResponseBodySize != null) {
            triple.setMaxResponseBodySize(this.maxResponseBodySize);
        }
        if (this.maxChunkSize != null) {
            triple.setMaxChunkSize(this.maxChunkSize);
        }
        if (this.maxHeaderSize != null) {
            triple.setMaxHeaderSize(this.maxHeaderSize);
        }
        if (this.maxInitialLineLength != null) {
            triple.setMaxInitialLineLength(this.maxInitialLineLength);
        }
        if (this.initialBufferSize != null) {
            triple.setInitialBufferSize(this.initialBufferSize);
        }
        if (this.headerTableSize != null) {
            triple.setHeaderTableSize(this.headerTableSize);
        }
        if (this.enablePush != null) {
            triple.setEnablePush(this.enablePush);
        }
        if (this.maxConcurrentStreams != null) {
            triple.setMaxConcurrentStreams(this.maxConcurrentStreams);
        }
        if (this.initialWindowSize != null) {
            triple.setInitialWindowSize(this.initialWindowSize);
        }
        if (this.maxFrameSize != null) {
            triple.setMaxFrameSize(this.maxFrameSize);
        }
        if (this.maxHeaderListSize != null) {
            triple.setMaxHeaderListSize(this.maxHeaderListSize);
        }
        return triple;
    }
}

