/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;

public class CompositeReferenceCache
implements ReferenceCache {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(CompositeReferenceCache.class);
    private final ApplicationModel applicationModel;

    public CompositeReferenceCache(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public <T> T get(ReferenceConfigBase<T> referenceConfig, boolean check) {
        Class type = referenceConfig.getInterfaceClass();
        String key = BaseServiceMetadata.buildServiceKey((String)type.getName(), (String)referenceConfig.getGroup(), (String)referenceConfig.getVersion());
        boolean singleton = referenceConfig.getSingleton() == null || referenceConfig.getSingleton() != false;
        Object proxy = null;
        if (singleton) {
            proxy = this.get(key, type);
        } else {
            logger.warn("5-27", "the api method is being used incorrectly", "", "Using non-singleton ReferenceConfig and ReferenceCache at the same time may cause memory leak. Call ReferenceConfig#get() directly for non-singleton ReferenceConfig instead of using ReferenceCache#get(ReferenceConfig)");
        }
        if (proxy == null) {
            proxy = referenceConfig.get(check);
        }
        return (T)proxy;
    }

    public <T> T get(String key, Class<T> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(key, type);
            if (proxy == null) continue;
            return (T)proxy;
        }
        return null;
    }

    public <T> T get(String key) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(key);
            if (proxy == null) continue;
            return (T)proxy;
        }
        return null;
    }

    public <T> List<T> getAll(Class<T> type) {
        ArrayList proxies = new ArrayList();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            proxies.addAll(moduleModel.getDeployer().getReferenceCache().getAll(type));
        }
        return proxies;
    }

    public <T> T get(Class<T> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(type);
            if (proxy == null) continue;
            return (T)proxy;
        }
        return null;
    }

    public void destroy(String key, Class<?> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroy(key, type);
        }
    }

    public void check(String key, Class<?> type, long timeout) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().check(key, type, timeout);
        }
    }

    public <T> void check(ReferenceConfigBase<T> referenceConfig, long timeout) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().check(referenceConfig, timeout);
        }
    }

    public void destroy(Class<?> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroy(type);
        }
    }

    public <T> void destroy(ReferenceConfigBase<T> referenceConfig) {
        referenceConfig.getScopeModel().getDeployer().getReferenceCache().destroy(referenceConfig);
    }

    public void destroyAll() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroyAll();
        }
    }
}

