/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractServiceConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractInterfaceBuilder;

public abstract class AbstractServiceBuilder<T extends AbstractServiceConfig, B extends AbstractServiceBuilder<T, B>>
extends AbstractInterfaceBuilder<T, B> {
    protected String version;
    protected String group;
    protected Boolean deprecated;
    protected Integer delay;
    protected Boolean export;
    protected Integer weight;
    protected String document;
    protected Boolean dynamic;
    protected String token;
    protected String accesslog;
    protected List<ProtocolConfig> protocols;
    protected String protocolIds;
    private Integer executes;
    private Boolean register;
    private Integer warmup;
    private String serialization;
    private Executor executor;
    private String preferSerialization;

    public B version(String version) {
        this.version = version;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B group(String group) {
        this.group = group;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B delay(Integer delay) {
        this.delay = delay;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B export(Boolean export) {
        this.export = export;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B weight(Integer weight) {
        this.weight = weight;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B document(String document) {
        this.document = document;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B dynamic(Boolean dynamic) {
        this.dynamic = dynamic;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B token(String token) {
        this.token = token;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B token(Boolean token) {
        this.token = token != null ? token.toString() : null;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B accesslog(String accesslog) {
        this.accesslog = accesslog;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B accesslog(Boolean accesslog) {
        this.accesslog = accesslog != null ? accesslog.toString() : null;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B addProtocols(List<ProtocolConfig> protocols) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<ProtocolConfig>();
        }
        this.protocols.addAll(protocols);
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B addProtocol(ProtocolConfig protocol) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<ProtocolConfig>();
        }
        this.protocols.add(protocol);
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B protocolIds(String protocolIds) {
        this.protocolIds = protocolIds;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B executes(Integer executes) {
        this.executes = executes;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B register(Boolean register) {
        this.register = register;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B warmup(Integer warmup) {
        this.warmup = warmup;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B serialization(String serialization) {
        this.serialization = serialization;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B executor(Executor executor) {
        this.executor = executor;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    public B preferSerialization(String preferSerialization) {
        this.preferSerialization = preferSerialization;
        return (B)((AbstractServiceBuilder)this.getThis());
    }

    @Override
    public void build(T instance) {
        super.build(instance);
        if (!StringUtils.isEmpty((String)this.version)) {
            instance.setVersion(this.version);
        }
        if (!StringUtils.isEmpty((String)this.group)) {
            instance.setGroup(this.group);
        }
        if (this.deprecated != null) {
            instance.setDeprecated(this.deprecated);
        }
        if (this.delay != null) {
            instance.setDelay(this.delay);
        }
        if (this.export != null) {
            instance.setExport(this.export);
        }
        if (this.weight != null) {
            instance.setWeight(this.weight);
        }
        if (!StringUtils.isEmpty((String)this.document)) {
            instance.setDocument(this.document);
        }
        if (this.dynamic != null) {
            instance.setDynamic(this.dynamic);
        }
        if (!StringUtils.isEmpty((String)this.token)) {
            instance.setToken(this.token);
        }
        if (!StringUtils.isEmpty((String)this.accesslog)) {
            instance.setAccesslog(this.accesslog);
        }
        if (this.protocols != null) {
            instance.setProtocols(this.protocols);
        }
        if (!StringUtils.isEmpty((String)this.protocolIds)) {
            instance.setProtocolIds(this.protocolIds);
        }
        if (this.executes != null) {
            instance.setExecutes(this.executes);
        }
        if (this.register != null) {
            instance.setRegister(this.register);
        }
        if (this.warmup != null) {
            instance.setWarmup(this.warmup);
        }
        if (!StringUtils.isEmpty((String)this.serialization)) {
            instance.setSerialization(this.serialization);
        }
        if (this.executor != null) {
            instance.setExecutor(this.executor);
        }
        if (StringUtils.isNotBlank((CharSequence)this.preferSerialization)) {
            instance.setPreferSerialization(this.preferSerialization);
        }
    }
}

