/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter
implements MetadataServiceExporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MetadataService metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;

    public ConfigurableMetadataServiceExporter(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public ConfigurableMetadataServiceExporter export() {
        if (!this.isExported()) {
            ServiceConfig serviceConfig = new ServiceConfig();
            serviceConfig.setApplication(this.getApplicationConfig());
            serviceConfig.setRegistries(this.getRegistries());
            serviceConfig.setProtocol(this.generateMetadataProtocol());
            serviceConfig.setInterface(MetadataService.class);
            serviceConfig.setRef(this.metadataService);
            serviceConfig.setGroup(this.getApplicationConfig().getName());
            serviceConfig.setVersion(this.metadataService.version());
            serviceConfig.export();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + serviceConfig.getExportedUrls());
            }
            this.serviceConfig = serviceConfig;
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
        }
        return this;
    }

    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }

    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported();
    }

    private ApplicationConfig getApplicationConfig() {
        return (ApplicationConfig)ApplicationModel.getConfigManager().getApplication().get();
    }

    private List<RegistryConfig> getRegistries() {
        return new ArrayList<RegistryConfig>(ApplicationModel.getConfigManager().getRegistries());
    }

    private ProtocolConfig generateMetadataProtocol() {
        ProtocolConfig defaultProtocol = new ProtocolConfig();
        defaultProtocol.setName("dubbo");
        defaultProtocol.setPort(Integer.valueOf(-1));
        return defaultProtocol;
    }
}

