/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.Map;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractBuilder;

public class RegistryBuilder
extends AbstractBuilder<RegistryConfig, RegistryBuilder> {
    private String address;
    private String username;
    private String password;
    private Integer port;
    private String protocol;
    private String transporter;
    private String server;
    private String client;
    private String cluster;
    private String group;
    private String version;
    private Integer timeout;
    private Integer session;
    private String file;
    private Integer wait;
    private Boolean check;
    private Boolean dynamic;
    private Boolean register;
    private Boolean subscribe;
    private Map<String, String> parameters;
    private Boolean isDefault;
    private Boolean simplified;
    private String extraKeys;
    private Boolean useAsConfigCenter;
    private Boolean useAsMetadataCenter;
    private String accepts;
    private Boolean preferred;
    private Integer weight;

    public static RegistryBuilder newBuilder() {
        return new RegistryBuilder();
    }

    @Override
    public RegistryBuilder id(String id) {
        return (RegistryBuilder)super.id(id);
    }

    public RegistryBuilder address(String address) {
        this.address = address;
        return this.getThis();
    }

    public RegistryBuilder username(String username) {
        this.username = username;
        return this.getThis();
    }

    public RegistryBuilder password(String password) {
        this.password = password;
        return this.getThis();
    }

    public RegistryBuilder port(Integer port) {
        this.port = port;
        return this.getThis();
    }

    public RegistryBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this.getThis();
    }

    public RegistryBuilder transporter(String transporter) {
        this.transporter = transporter;
        return this.getThis();
    }

    @Deprecated
    public RegistryBuilder transport(String transport) {
        this.transporter = transport;
        return this.getThis();
    }

    public RegistryBuilder server(String server) {
        this.server = server;
        return this.getThis();
    }

    public RegistryBuilder client(String client) {
        this.client = client;
        return this.getThis();
    }

    public RegistryBuilder cluster(String cluster) {
        this.cluster = cluster;
        return this.getThis();
    }

    public RegistryBuilder group(String group) {
        this.group = group;
        return this.getThis();
    }

    public RegistryBuilder version(String version) {
        this.version = version;
        return this.getThis();
    }

    public RegistryBuilder timeout(Integer timeout) {
        this.timeout = timeout;
        return this.getThis();
    }

    public RegistryBuilder session(Integer session) {
        this.session = session;
        return this.getThis();
    }

    public RegistryBuilder file(String file) {
        this.file = file;
        return this.getThis();
    }

    @Deprecated
    public RegistryBuilder wait(Integer wait) {
        this.wait = wait;
        return this.getThis();
    }

    public RegistryBuilder isCheck(Boolean check) {
        this.check = check;
        return this.getThis();
    }

    public RegistryBuilder isDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
        return this.getThis();
    }

    public RegistryBuilder register(Boolean register) {
        this.register = register;
        return this.getThis();
    }

    public RegistryBuilder subscribe(Boolean subscribe) {
        this.subscribe = subscribe;
        return this.getThis();
    }

    public RegistryBuilder appendParameter(String key, String value) {
        this.parameters = RegistryBuilder.appendParameter(this.parameters, key, value);
        return this.getThis();
    }

    public RegistryBuilder appendParameters(Map<String, String> appendParameters) {
        this.parameters = RegistryBuilder.appendParameters(this.parameters, appendParameters);
        return this.getThis();
    }

    public RegistryBuilder isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this.getThis();
    }

    public RegistryBuilder simplified(Boolean simplified) {
        this.simplified = simplified;
        return this.getThis();
    }

    public RegistryBuilder extraKeys(String extraKeys) {
        this.extraKeys = extraKeys;
        return this.getThis();
    }

    public RegistryBuilder useAsConfigCenter(Boolean useAsConfigCenter) {
        this.useAsConfigCenter = useAsConfigCenter;
        return this.getThis();
    }

    public RegistryBuilder useAsMetadataCenter(Boolean useAsMetadataCenter) {
        this.useAsMetadataCenter = useAsMetadataCenter;
        return this.getThis();
    }

    public RegistryBuilder preferred(Boolean preferred) {
        this.preferred = preferred;
        return this.getThis();
    }

    public RegistryBuilder accepts(String accepts) {
        this.accepts = accepts;
        return this.getThis();
    }

    public RegistryBuilder weight(Integer weight) {
        this.weight = weight;
        return this.getThis();
    }

    @Override
    public RegistryConfig build() {
        RegistryConfig registry = new RegistryConfig();
        super.build(registry);
        registry.setAddress(this.address);
        registry.setCheck(this.check);
        registry.setClient(this.client);
        registry.setCluster(this.cluster);
        registry.setDefault(this.isDefault);
        registry.setDynamic(this.dynamic);
        registry.setExtraKeys(this.extraKeys);
        registry.setFile(this.file);
        registry.setGroup(this.group);
        registry.setParameters(this.parameters);
        registry.setPassword(this.password);
        registry.setPort(this.port);
        registry.setProtocol(this.protocol);
        registry.setRegister(this.register);
        registry.setServer(this.server);
        registry.setSession(this.session);
        registry.setSimplified(this.simplified);
        registry.setSubscribe(this.subscribe);
        registry.setTimeout(this.timeout);
        registry.setTransporter(this.transporter);
        registry.setUsername(this.username);
        registry.setVersion(this.version);
        registry.setWait(this.wait);
        registry.setUseAsConfigCenter(this.useAsConfigCenter);
        registry.setUseAsMetadataCenter(this.useAsMetadataCenter);
        registry.setAccepts(this.accepts);
        registry.setPreferred(this.preferred);
        registry.setWeight(this.weight);
        return registry;
    }

    @Override
    protected RegistryBuilder getThis() {
        return this;
    }
}

