/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractReferenceBuilder;

public class ReferenceBuilder<T>
extends AbstractReferenceBuilder<ReferenceConfig, ReferenceBuilder<T>> {
    private String interfaceName;
    private Class<?> interfaceClass;
    private String client;
    private String url;
    private List<MethodConfig> methods;
    private ConsumerConfig consumer;
    private String protocol;

    public static ReferenceBuilder newBuilder() {
        return new ReferenceBuilder();
    }

    @Override
    public ReferenceBuilder<T> id(String id) {
        return (ReferenceBuilder)super.id(id);
    }

    public ReferenceBuilder<T> interfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this.getThis();
    }

    public ReferenceBuilder<T> interfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return this.getThis();
    }

    public ReferenceBuilder<T> client(String client) {
        this.client = client;
        return this.getThis();
    }

    public ReferenceBuilder<T> url(String url) {
        this.url = url;
        return this.getThis();
    }

    public ReferenceBuilder<T> addMethods(List<MethodConfig> methods) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodConfig>();
        }
        this.methods.addAll(methods);
        return this.getThis();
    }

    public ReferenceBuilder<T> addMethod(MethodConfig method) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodConfig>();
        }
        this.methods.add(method);
        return this.getThis();
    }

    public ReferenceBuilder<T> consumer(ConsumerConfig consumer) {
        this.consumer = consumer;
        return this.getThis();
    }

    public ReferenceBuilder<T> protocol(String protocol) {
        this.protocol = protocol;
        return this.getThis();
    }

    @Override
    public ReferenceConfig<T> build() {
        ReferenceConfig reference = new ReferenceConfig();
        super.build(reference);
        reference.setInterface(this.interfaceName);
        if (this.interfaceClass != null) {
            reference.setInterface(this.interfaceClass);
        }
        reference.setClient(this.client);
        reference.setUrl(this.url);
        reference.setMethods(this.methods);
        reference.setConsumer(this.consumer);
        reference.setProtocol(this.protocol);
        return reference;
    }

    @Override
    protected ReferenceBuilder<T> getThis() {
        return this;
    }
}

