/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConfigInitializer;
import org.apache.dubbo.config.ConfigPostProcessor;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.event.ServiceConfigExportedEvent;
import org.apache.dubbo.config.event.ServiceConfigUnexportedEvent;
import org.apache.dubbo.config.invoker.DelegateProviderMetaDataInvoker;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.ConfiguratorFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ServiceConfig<T>
extends ServiceConfigBase<T> {
    public static final Logger logger = LoggerFactory.getLogger(ServiceConfig.class);
    private static final Map<String, Integer> RANDOM_PORT_MAP = new HashMap<String, Integer>();
    private static final ScheduledExecutorService DELAY_EXPORT_EXECUTOR = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("DubboServiceDelayExporter", true));
    private String serviceName;
    private static final Protocol PROTOCOL = (Protocol)ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    private static final ProxyFactory PROXY_FACTORY = (ProxyFactory)ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private volatile transient boolean exported;
    private volatile transient boolean unexported;
    private DubboBootstrap bootstrap;
    private final List<Exporter<?>> exporters = new ArrayList();
    private static final String CONFIG_INITIALIZER_PROTOCOL = "configInitializer://";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private static final String STUB_SUFFIX = "Stub";
    private static final String LOCAL_SUFFIX = "Local";
    private static final String CONFIG_POST_PROCESSOR_PROTOCOL = "configPostProcessor://";
    private static final String RETRY_SUFFIX = ".retry";
    private static final String RETRIES_SUFFIX = ".retries";
    private static final String ZERO_VALUE = "0";

    public ServiceConfig() {
    }

    public ServiceConfig(Service service) {
        super(service);
    }

    @Parameter(excluded=true)
    public boolean isExported() {
        return this.exported;
    }

    @Parameter(excluded=true)
    public boolean isUnexported() {
        return this.unexported;
    }

    public void unexport() {
        if (!this.exported) {
            return;
        }
        if (this.unexported) {
            return;
        }
        if (!this.exporters.isEmpty()) {
            for (Exporter<?> exporter : this.exporters) {
                try {
                    exporter.unexport();
                }
                catch (Throwable t) {
                    logger.warn("Unexpected error occurred when unexport " + exporter, t);
                }
            }
            this.exporters.clear();
        }
        this.unexported = true;
        this.dispatch(new ServiceConfigUnexportedEvent(this));
    }

    public synchronized void export() {
        if (this.bootstrap == null) {
            this.bootstrap = DubboBootstrap.getInstance();
            if (null != this.getRegistry()) {
                this.bootstrap.registries(this.getRegistries());
            }
            this.bootstrap.initialize();
        }
        this.checkAndUpdateSubConfigs();
        this.initServiceMetadata((AbstractInterfaceConfig)this.provider);
        this.serviceMetadata.setServiceType(this.getInterfaceClass());
        this.serviceMetadata.setTarget(this.getRef());
        this.serviceMetadata.generateServiceKey();
        if (!this.shouldExport()) {
            return;
        }
        if (this.shouldDelay()) {
            DELAY_EXPORT_EXECUTOR.schedule(() -> {
                try {
                    this.doExport();
                }
                catch (Exception e) {
                    logger.error("delay export server occur exception, please check it.", (Throwable)e);
                }
            }, (long)this.getDelay().intValue(), TimeUnit.MILLISECONDS);
        } else {
            this.doExport();
        }
        this.exported();
    }

    public void exported() {
        List exportedURLs = this.getExportedUrls();
        exportedURLs.forEach(url -> {
            if (url.getParameters().containsKey("service-name-mapping")) {
                Map parameters = this.getApplication().getParameters();
                ServiceNameMapping.getExtension(parameters != null ? (String)parameters.get("mapping-type") : null).map(url);
            }
        });
        this.dispatch(new ServiceConfigExportedEvent(this));
    }

    private void checkAndUpdateSubConfigs() {
        this.completeCompoundConfigs();
        this.checkDefault();
        this.checkProtocol();
        List configInitializers = ExtensionLoader.getExtensionLoader(ConfigInitializer.class).getActivateExtension(URL.valueOf((String)CONFIG_INITIALIZER_PROTOCOL), (String[])null);
        configInitializers.forEach(e -> e.initServiceConfig(this));
        if (!this.isOnlyInJvm()) {
            this.checkRegistry();
        }
        this.refresh();
        if (StringUtils.isEmpty((String)this.interfaceName)) {
            throw new IllegalStateException("<dubbo:service interface=\"\" /> interface not allow null!");
        }
        if (this.ref instanceof GenericService) {
            this.interfaceClass = GenericService.class;
            if (StringUtils.isEmpty((String)this.generic)) {
                this.generic = TRUE_VALUE;
            }
        } else {
            try {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException(e2.getMessage(), e2);
            }
            this.checkInterfaceAndMethods(this.interfaceClass, this.getMethods());
            this.checkRef();
            this.generic = FALSE_VALUE;
        }
        this.checkStubAndLocal(this.interfaceClass);
        ConfigValidationUtils.checkMock(this.interfaceClass, (AbstractInterfaceConfig)this);
        ConfigValidationUtils.validateServiceConfig(this);
        this.postProcessConfig();
    }

    protected synchronized void doExport() {
        if (this.unexported) {
            throw new IllegalStateException("The service " + this.interfaceClass.getName() + " has already unexported!");
        }
        if (this.exported) {
            return;
        }
        this.exported = true;
        if (StringUtils.isEmpty((String)this.path)) {
            this.path = this.interfaceName;
        }
        this.doExportUrls();
        this.bootstrap.setReady(true);
    }

    private void doExportUrls() {
        ServiceRepository repository = ApplicationModel.getServiceRepository();
        ServiceDescriptor serviceDescriptor = repository.registerService(this.getInterfaceClass());
        repository.registerProvider(this.getUniqueServiceName(), this.ref, serviceDescriptor, (ServiceConfigBase)this, this.serviceMetadata);
        List<URL> registryURLs = ConfigValidationUtils.loadRegistries((AbstractInterfaceConfig)this, true);
        int protocolConfigNum = this.protocols.size();
        for (ProtocolConfig protocolConfig : this.protocols) {
            String pathKey = URL.buildKey((String)this.getContextPath(protocolConfig).map(p -> p + "/" + this.path).orElse(this.path), (String)this.group, (String)this.version);
            repository.registerService(pathKey, this.interfaceClass);
            this.doExportUrlsFor1Protocol(protocolConfig, registryURLs, protocolConfigNum);
        }
    }

    private void doExportUrlsFor1Protocol(ProtocolConfig protocolConfig, List<URL> registryURLs, int protocolConfigNum) {
        String scope;
        String name = protocolConfig.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = "dubbo";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("side", "provider");
        ServiceConfig.appendRuntimeParameters(map);
        AbstractConfig.appendParameters(map, (Object)this.getMetrics());
        AbstractConfig.appendParameters(map, (Object)this.getApplication());
        AbstractConfig.appendParameters(map, (Object)this.getModule());
        AbstractConfig.appendParameters(map, (Object)this.provider);
        AbstractConfig.appendParameters(map, (Object)protocolConfig);
        AbstractConfig.appendParameters(map, (Object)((Object)this));
        MetadataReportConfig metadataReportConfig = this.getMetadataReportConfig();
        if (metadataReportConfig != null && metadataReportConfig.isValid()) {
            map.putIfAbsent("metadata-type", "remote");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getMethods())) {
            for (MethodConfig method : this.getMethods()) {
                List arguments;
                String retryValue;
                AbstractConfig.appendParameters(map, (Object)method, (String)method.getName());
                String retryKey = method.getName() + RETRY_SUFFIX;
                if (map.containsKey(retryKey) && FALSE_VALUE.equals(retryValue = (String)map.remove(retryKey))) {
                    map.put(method.getName() + RETRIES_SUFFIX, ZERO_VALUE);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(arguments = method.getArguments()))) continue;
                for (ArgumentConfig argument : arguments) {
                    if (argument.getType() != null && argument.getType().length() > 0) {
                        Method[] methods = this.interfaceClass.getMethods();
                        if (methods.length <= 0) continue;
                        for (int i = 0; i < methods.length; ++i) {
                            String methodName = methods[i].getName();
                            if (!methodName.equals(method.getName())) continue;
                            Class<?>[] argtypes = methods[i].getParameterTypes();
                            if (argument.getIndex() != -1) {
                                if (argtypes[argument.getIndex()].getName().equals(argument.getType())) {
                                    AbstractConfig.appendParameters(map, (Object)argument, (String)(method.getName() + "." + argument.getIndex()));
                                    continue;
                                }
                                throw new IllegalArgumentException("Argument config error : the index attribute and type attribute not match :index :" + argument.getIndex() + ", type:" + argument.getType());
                            }
                            for (int j = 0; j < argtypes.length; ++j) {
                                Class<?> argclazz = argtypes[j];
                                if (!argclazz.getName().equals(argument.getType())) continue;
                                AbstractConfig.appendParameters(map, (Object)argument, (String)(method.getName() + "." + j));
                                if (argument.getIndex() == -1 || argument.getIndex() == j) continue;
                                throw new IllegalArgumentException("Argument config error : the index attribute and type attribute not match :index :" + argument.getIndex() + ", type:" + argument.getType());
                            }
                        }
                        continue;
                    }
                    if (argument.getIndex() != -1) {
                        AbstractConfig.appendParameters(map, (Object)argument, (String)(method.getName() + "." + argument.getIndex()));
                        continue;
                    }
                    throw new IllegalArgumentException("Argument config must set index or type attribute.eg: <dubbo:argument index='0' .../> or <dubbo:argument type=xxx .../>");
                }
            }
        }
        if (ProtocolUtils.isGeneric((String)this.generic)) {
            map.put("generic", this.generic);
            map.put("methods", "*");
        } else {
            String[] methods;
            String revision = Version.getVersion((Class)this.interfaceClass, (String)this.version);
            if (revision != null && revision.length() > 0) {
                map.put("revision", revision);
            }
            if ((methods = Wrapper.getWrapper((Class)this.interfaceClass).getMethodNames()).length == 0) {
                logger.warn("No method found in service interface " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new HashSet<String>(Arrays.asList(methods)), (String)","));
            }
        }
        if (ConfigUtils.isEmpty((String)this.token) && this.provider != null) {
            this.token = this.provider.getToken();
        }
        if (!ConfigUtils.isEmpty((String)this.token)) {
            if (ConfigUtils.isDefault((String)this.token)) {
                map.put("token", UUID.randomUUID().toString());
            } else {
                map.put("token", this.token);
            }
        }
        this.serviceMetadata.getAttachments().putAll(map);
        String host = this.findConfigedHosts(protocolConfig, registryURLs, map);
        Integer port = this.findConfigedPorts(protocolConfig, name, map, protocolConfigNum);
        URL url = new URL(name, host, port.intValue(), this.getContextPath(protocolConfig).map(p -> p + "/" + this.path).orElse(this.path), map);
        if (ExtensionLoader.getExtensionLoader(ConfiguratorFactory.class).hasExtension(url.getProtocol())) {
            url = ((ConfiguratorFactory)ExtensionLoader.getExtensionLoader(ConfiguratorFactory.class).getExtension(url.getProtocol())).getConfigurator(url).configure(url);
        }
        if (!"none".equalsIgnoreCase(scope = url.getParameter("scope"))) {
            if (!"remote".equalsIgnoreCase(scope)) {
                this.exportLocal(url);
            }
            if (!"local".equalsIgnoreCase(scope)) {
                if (CollectionUtils.isNotEmpty(registryURLs)) {
                    for (URL registryURL : registryURLs) {
                        String proxy;
                        if ("service-discovery-registry".equals(registryURL.getProtocol())) {
                            url = url.addParameterIfAbsent("service-name-mapping", TRUE_VALUE);
                        }
                        if ("injvm".equalsIgnoreCase(url.getProtocol())) continue;
                        url = url.addParameterIfAbsent("dynamic", registryURL.getParameter("dynamic"));
                        URL monitorUrl = ConfigValidationUtils.loadMonitor((AbstractInterfaceConfig)this, registryURL);
                        if (monitorUrl != null) {
                            url = url.addParameterAndEncoded("monitor", monitorUrl.toFullString());
                        }
                        if (logger.isInfoEnabled()) {
                            if (url.getParameter("register", true)) {
                                logger.info("Register dubbo service " + this.interfaceClass.getName() + " url " + url + " to registry " + registryURL);
                            } else {
                                logger.info("Export dubbo service " + this.interfaceClass.getName() + " to url " + url);
                            }
                        }
                        if (StringUtils.isNotEmpty((String)(proxy = url.getParameter("proxy")))) {
                            registryURL = registryURL.addParameter("proxy", proxy);
                        }
                        Invoker invoker = PROXY_FACTORY.getInvoker(this.ref, this.interfaceClass, registryURL.addParameterAndEncoded("export", url.toFullString()));
                        DelegateProviderMetaDataInvoker wrapperInvoker = new DelegateProviderMetaDataInvoker(invoker, this);
                        Exporter exporter = PROTOCOL.export(wrapperInvoker);
                        this.exporters.add(exporter);
                    }
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info("Export dubbo service " + this.interfaceClass.getName() + " to url " + url);
                    }
                    Invoker invoker = PROXY_FACTORY.getInvoker(this.ref, this.interfaceClass, url);
                    DelegateProviderMetaDataInvoker wrapperInvoker = new DelegateProviderMetaDataInvoker(invoker, this);
                    Exporter exporter = PROTOCOL.export(wrapperInvoker);
                    this.exporters.add(exporter);
                }
                MetadataUtils.publishServiceDefinition((URL)url);
            }
        }
        this.urls.add(url);
    }

    private void exportLocal(URL url) {
        URL local = URLBuilder.from((URL)url).setProtocol("injvm").setHost("127.0.0.1").setPort(0).build();
        Exporter exporter = PROTOCOL.export(PROXY_FACTORY.getInvoker(this.ref, this.interfaceClass, local));
        this.exporters.add(exporter);
        logger.info("Export dubbo service " + this.interfaceClass.getName() + " to local registry url : " + local);
    }

    private boolean isOnlyInJvm() {
        return this.getProtocols().size() == 1 && "injvm".equalsIgnoreCase(((ProtocolConfig)this.getProtocols().get(0)).getName());
    }

    private String findConfigedHosts(ProtocolConfig protocolConfig, List<URL> registryURLs, Map<String, String> map) {
        boolean anyhost = false;
        String hostToBind = this.getValueFromConfig(protocolConfig, "DUBBO_IP_TO_BIND");
        if (hostToBind != null && hostToBind.length() > 0 && NetUtils.isInvalidLocalHost((String)hostToBind)) {
            throw new IllegalArgumentException("Specified invalid bind ip from property:DUBBO_IP_TO_BIND, value:" + hostToBind);
        }
        if (StringUtils.isEmpty((String)hostToBind)) {
            hostToBind = protocolConfig.getHost();
            if (this.provider != null && StringUtils.isEmpty((String)hostToBind)) {
                hostToBind = this.provider.getHost();
            }
            if (NetUtils.isInvalidLocalHost((String)hostToBind)) {
                anyhost = true;
                try {
                    logger.info("No valid ip found from environment, try to find valid host from DNS.");
                    hostToBind = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                if (NetUtils.isInvalidLocalHost((String)hostToBind)) {
                    if (CollectionUtils.isNotEmpty(registryURLs)) {
                        for (URL registryURL : registryURLs) {
                            if ("multicast".equalsIgnoreCase(registryURL.getParameter("registry")) || "multiple".equalsIgnoreCase(registryURL.getParameter("registry"))) continue;
                            try (Socket socket = new Socket();){
                                InetSocketAddress addr = new InetSocketAddress(registryURL.getHost(), registryURL.getPort());
                                socket.connect(addr, 1000);
                                hostToBind = socket.getLocalAddress().getHostAddress();
                                break;
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (NetUtils.isInvalidLocalHost((String)hostToBind)) {
                        hostToBind = NetUtils.getLocalHost();
                    }
                }
            }
        }
        map.put("bind.ip", hostToBind);
        String hostToRegistry = this.getValueFromConfig(protocolConfig, "DUBBO_IP_TO_REGISTRY");
        if (hostToRegistry != null && hostToRegistry.length() > 0 && NetUtils.isInvalidLocalHost((String)hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        if (StringUtils.isEmpty((String)hostToRegistry)) {
            hostToRegistry = hostToBind;
        }
        map.put("anyhost", String.valueOf(anyhost));
        return hostToRegistry;
    }

    private Integer findConfigedPorts(ProtocolConfig protocolConfig, String name, Map<String, String> map, int protocolConfigNum) {
        String portToRegistryStr;
        Integer portToRegistry;
        Integer portToBind = null;
        String port = this.getValueFromConfig(protocolConfig, "DUBBO_PORT_TO_BIND");
        portToBind = this.parsePort(port);
        if (portToBind == null) {
            portToBind = protocolConfig.getPort();
            if (this.provider != null && (portToBind == null || portToBind == 0)) {
                portToBind = this.provider.getPort();
            }
            int defaultPort = ((Protocol)ExtensionLoader.getExtensionLoader(Protocol.class).getExtension(name)).getDefaultPort();
            if (portToBind == null || portToBind == 0) {
                portToBind = defaultPort;
            }
            if (portToBind <= 0 && ((portToBind = this.getRandomPort(name)) == null || portToBind < 0)) {
                portToBind = NetUtils.getAvailablePort((int)defaultPort);
                this.putRandomPort(name, portToBind);
            }
        }
        String key = "DUBBO_PORT_TO_REGISTRY";
        if (protocolConfigNum > 1) {
            key = this.getProtocolConfigId(protocolConfig).toUpperCase() + "_" + key;
        }
        if ((portToRegistry = this.parsePort(portToRegistryStr = this.getValueFromConfig(protocolConfig, key))) == null) {
            portToRegistry = portToBind;
        }
        map.put("bind.port", String.valueOf(portToRegistry));
        return portToRegistry;
    }

    private String getProtocolConfigId(ProtocolConfig config) {
        return Optional.ofNullable(config.getId()).orElse("dubbo");
    }

    private Integer parsePort(String configPort) {
        Integer port = null;
        if (configPort != null && configPort.length() > 0) {
            try {
                Integer intPort = Integer.parseInt(configPort);
                if (NetUtils.isInvalidPort((int)intPort)) {
                    throw new IllegalArgumentException("Specified invalid port from env value:" + configPort);
                }
                port = intPort;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Specified invalid port from env value:" + configPort);
            }
        }
        return port;
    }

    private String getValueFromConfig(ProtocolConfig protocolConfig, String key) {
        String protocolPrefix = protocolConfig.getName().toUpperCase() + "_";
        String value = ConfigUtils.getSystemProperty((String)(protocolPrefix + key));
        if (StringUtils.isEmpty((String)value)) {
            value = ConfigUtils.getSystemProperty((String)key);
        }
        return value;
    }

    private Integer getRandomPort(String protocol) {
        protocol = protocol.toLowerCase();
        return RANDOM_PORT_MAP.getOrDefault(protocol, Integer.MIN_VALUE);
    }

    private void putRandomPort(String protocol, Integer port) {
        if (!RANDOM_PORT_MAP.containsKey(protocol = protocol.toLowerCase())) {
            RANDOM_PORT_MAP.put(protocol, port);
            logger.warn("Use random available port(" + port + ") for protocol " + protocol);
        }
    }

    private void postProcessConfig() {
        List configPostProcessors = ExtensionLoader.getExtensionLoader(ConfigPostProcessor.class).getActivateExtension(URL.valueOf((String)CONFIG_POST_PROCESSOR_PROTOCOL), (String[])null);
        configPostProcessors.forEach(component -> component.postProcessServiceConfig(this));
    }

    private void dispatch(Event event) {
        EventDispatcher.getDefaultExtension().dispatch(event);
    }

    public DubboBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(DubboBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public String getServiceName() {
        if (!StringUtils.isBlank((CharSequence)this.serviceName)) {
            return this.serviceName;
        }
        String generateVersion = this.version;
        String generateGroup = this.group;
        if (StringUtils.isBlank((CharSequence)this.version) && this.provider != null) {
            generateVersion = this.provider.getVersion();
        }
        if (StringUtils.isBlank((CharSequence)this.group) && this.provider != null) {
            generateGroup = this.provider.getGroup();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ServiceBean:");
        if (!StringUtils.isBlank((CharSequence)generateGroup)) {
            stringBuilder.append(generateGroup);
        }
        stringBuilder.append("/").append(this.interfaceName);
        if (!StringUtils.isBlank((CharSequence)generateVersion)) {
            stringBuilder.append(":").append(generateVersion);
        }
        this.serviceName = stringBuilder.toString();
        return this.serviceName;
    }
}

