/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;

public class ConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    private static final ConfigManager configManager = new ConfigManager();
    private ApplicationConfig application;
    private MonitorConfig monitor;
    private ModuleConfig module;
    private ConfigCenterConfig configCenter;
    private Map<String, ProtocolConfig> protocols = new ConcurrentHashMap<String, ProtocolConfig>();
    private Map<String, RegistryConfig> registries = new ConcurrentHashMap<String, RegistryConfig>();
    private Map<String, ProviderConfig> providers = new ConcurrentHashMap<String, ProviderConfig>();
    private Map<String, ConsumerConfig> consumers = new ConcurrentHashMap<String, ConsumerConfig>();

    public static ConfigManager getInstance() {
        return configManager;
    }

    private ConfigManager() {
    }

    public Optional<ApplicationConfig> getApplication() {
        return Optional.ofNullable(this.application);
    }

    public void setApplication(ApplicationConfig application) {
        if (application != null) {
            this.checkDuplicate(this.application, application);
            this.application = application;
        }
    }

    public Optional<MonitorConfig> getMonitor() {
        return Optional.ofNullable(this.monitor);
    }

    public void setMonitor(MonitorConfig monitor) {
        if (monitor != null) {
            this.checkDuplicate(this.monitor, monitor);
            this.monitor = monitor;
        }
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable(this.module);
    }

    public void setModule(ModuleConfig module) {
        if (module != null) {
            this.checkDuplicate(this.module, module);
            this.module = module;
        }
    }

    public Optional<ConfigCenterConfig> getConfigCenter() {
        return Optional.ofNullable(this.configCenter);
    }

    public void setConfigCenter(ConfigCenterConfig configCenter) {
        if (configCenter != null) {
            this.checkDuplicate(this.configCenter, configCenter);
            this.configCenter = configCenter;
        }
    }

    public Optional<ProviderConfig> getProvider(String id) {
        return Optional.ofNullable(this.providers.get(id));
    }

    public Optional<ProviderConfig> getDefaultProvider() {
        return Optional.ofNullable(this.providers.get("default"));
    }

    public void addProvider(ProviderConfig providerConfig) {
        String key;
        if (providerConfig == null) {
            return;
        }
        String string = StringUtils.isNotEmpty((String)providerConfig.getId()) ? providerConfig.getId() : (key = providerConfig.isDefault() == null || providerConfig.isDefault() != false ? "default" : null);
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalStateException("A ProviderConfig should either has an id or it's the default one, " + providerConfig);
        }
        if (this.providers.containsKey(key) && !providerConfig.equals(this.providers.get(key))) {
            logger.warn("Duplicate ProviderConfig found, there already has one default ProviderConfig or more than two ProviderConfigs have the same id, you can try to give each ProviderConfig a different id. " + providerConfig);
        } else {
            this.providers.put(key, providerConfig);
        }
    }

    public Optional<ConsumerConfig> getConsumer(String id) {
        return Optional.ofNullable(this.consumers.get(id));
    }

    public Optional<ConsumerConfig> getDefaultConsumer() {
        return Optional.ofNullable(this.consumers.get("default"));
    }

    public void addConsumer(ConsumerConfig consumerConfig) {
        String key;
        if (consumerConfig == null) {
            return;
        }
        String string = StringUtils.isNotEmpty((String)consumerConfig.getId()) ? consumerConfig.getId() : (key = consumerConfig.isDefault() == null || consumerConfig.isDefault() != false ? "default" : null);
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalStateException("A ConsumerConfig should either has an id or it's the default one, " + consumerConfig);
        }
        if (this.consumers.containsKey(key) && !consumerConfig.equals(this.consumers.get(key))) {
            logger.warn("Duplicate ConsumerConfig found, there already has one default ConsumerConfig or more than two ConsumerConfigs have the same id, you can try to give each ConsumerConfig a different id. " + consumerConfig);
        } else {
            this.consumers.put(key, consumerConfig);
        }
    }

    public Optional<ProtocolConfig> getProtocol(String id) {
        return Optional.ofNullable(this.protocols.get(id));
    }

    public Optional<List<ProtocolConfig>> getDefaultProtocols() {
        ArrayList defaults = new ArrayList();
        this.protocols.forEach((k, v) -> {
            if ("default".equalsIgnoreCase((String)k)) {
                defaults.add(v);
            } else if (v.isDefault() == null || v.isDefault().booleanValue()) {
                defaults.add(v);
            }
        });
        return Optional.of(defaults);
    }

    public void addProtocols(List<ProtocolConfig> protocolConfigs) {
        if (protocolConfigs != null) {
            protocolConfigs.forEach(this::addProtocol);
        }
    }

    public void addProtocol(ProtocolConfig protocolConfig) {
        String key;
        if (protocolConfig == null) {
            return;
        }
        String string = StringUtils.isNotEmpty((String)protocolConfig.getId()) ? protocolConfig.getId() : (key = protocolConfig.isDefault() == null || protocolConfig.isDefault() != false ? "default" : null);
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalStateException("A ProtocolConfig should either has an id or it's the default one, " + protocolConfig);
        }
        if (this.protocols.containsKey(key) && !protocolConfig.equals(this.protocols.get(key))) {
            logger.warn("Duplicate ProtocolConfig found, there already has one default ProtocolConfig or more than two ProtocolConfigs have the same id, you can try to give each ProtocolConfig a different id. " + protocolConfig);
        } else {
            this.protocols.put(key, protocolConfig);
        }
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return Optional.ofNullable(this.registries.get(id));
    }

    public Optional<List<RegistryConfig>> getDefaultRegistries() {
        ArrayList defaults = new ArrayList();
        this.registries.forEach((k, v) -> {
            if ("default".equalsIgnoreCase((String)k)) {
                defaults.add(v);
            } else if (v.isDefault() == null || v.isDefault().booleanValue()) {
                defaults.add(v);
            }
        });
        return Optional.of(defaults);
    }

    public void addRegistries(List<RegistryConfig> registryConfigs) {
        if (registryConfigs != null) {
            registryConfigs.forEach(this::addRegistry);
        }
    }

    public void addRegistry(RegistryConfig registryConfig) {
        String key;
        if (registryConfig == null) {
            return;
        }
        String string = StringUtils.isNotEmpty((String)registryConfig.getId()) ? registryConfig.getId() : (key = registryConfig.isDefault() == null || registryConfig.isDefault() != false ? "default" : null);
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalStateException("A RegistryConfig should either has an id or it's the default one, " + registryConfig);
        }
        if (this.registries.containsKey(key) && !registryConfig.equals(this.registries.get(key))) {
            logger.warn("Duplicate RegistryConfig found, there already has one default RegistryConfig or more than two RegistryConfigs have the same id, you can try to give each RegistryConfig a different id. " + registryConfig);
        } else {
            this.registries.put(key, registryConfig);
        }
    }

    public Map<String, ProtocolConfig> getProtocols() {
        return this.protocols;
    }

    public Map<String, RegistryConfig> getRegistries() {
        return this.registries;
    }

    public Map<String, ProviderConfig> getProviders() {
        return this.providers;
    }

    public Map<String, ConsumerConfig> getConsumers() {
        return this.consumers;
    }

    public void refreshAll() {
        this.getApplication().ifPresent(AbstractConfig::refresh);
        this.getMonitor().ifPresent(AbstractConfig::refresh);
        this.getModule().ifPresent(AbstractConfig::refresh);
        this.getProtocols().values().forEach(ProtocolConfig::refresh);
        this.getRegistries().values().forEach(RegistryConfig::refresh);
        this.getProviders().values().forEach(AbstractConfig::refresh);
        this.getConsumers().values().forEach(AbstractConfig::refresh);
    }

    private void checkDuplicate(AbstractConfig oldOne, AbstractConfig newOne) {
        if (oldOne != null && !oldOne.equals(newOne)) {
            String configName = oldOne.getClass().getSimpleName();
            throw new IllegalStateException("Duplicate Config found for " + configName + ", you should use only one unique " + configName + " for one application.");
        }
    }

    public void clear() {
        this.application = null;
        this.configCenter = null;
        this.monitor = null;
        this.module = null;
        this.registries.clear();
        this.protocols.clear();
        this.providers.clear();
        this.consumers.clear();
    }
}

