/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.Protocol;

public class DubboShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DubboShutdownHook.class);
    private static final DubboShutdownHook dubboShutdownHook = new DubboShutdownHook("DubboShutdownHook");
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    private DubboShutdownHook(String name) {
        super(name);
    }

    public static DubboShutdownHook getDubboShutdownHook() {
        return dubboShutdownHook;
    }

    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info("Run shutdown hook now.");
        }
        this.doDestroy();
    }

    public void register() {
        if (!this.registered.get() && this.registered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(DubboShutdownHook.getDubboShutdownHook());
        }
    }

    public void unregister() {
        if (this.registered.get() && this.registered.compareAndSet(true, false)) {
            Runtime.getRuntime().removeShutdownHook(DubboShutdownHook.getDubboShutdownHook());
        }
    }

    public void doDestroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        AbstractRegistryFactory.destroyAll();
        this.destroyProtocols();
    }

    private void destroyProtocols() {
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(Protocol.class);
        for (String protocolName : loader.getLoadedExtensions()) {
            try {
                Protocol protocol = (Protocol)loader.getLoadedExtension(protocolName);
                if (protocol == null) continue;
                protocol.destroy();
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }
}

