/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.compact;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class Dubbo2ActivateUtils {
    private static final Class<? extends Annotation> ACTIVATE_CLASS = Dubbo2ActivateUtils.loadClass();
    private static final Method GROUP_METHOD = Dubbo2ActivateUtils.loadMethod("group");
    private static final Method VALUE_METHOD = Dubbo2ActivateUtils.loadMethod("value");
    private static final Method BEFORE_METHOD = Dubbo2ActivateUtils.loadMethod("before");
    private static final Method AFTER_METHOD = Dubbo2ActivateUtils.loadMethod("after");
    private static final Method ORDER_METHOD = Dubbo2ActivateUtils.loadMethod("order");
    private static final Method ON_CLASS_METHOD = Dubbo2ActivateUtils.loadMethod("onClass");

    private static Class<? extends Annotation> loadClass() {
        try {
            Class<?> clazz = Class.forName("com.alibaba.dubbo.common.extension.Activate");
            if (clazz.isAnnotation()) {
                return clazz;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isActivateLoaded() {
        return ACTIVATE_CLASS != null;
    }

    public static Class<? extends Annotation> getActivateClass() {
        return ACTIVATE_CLASS;
    }

    private static Method loadMethod(String name) {
        if (ACTIVATE_CLASS == null) {
            return null;
        }
        try {
            return ACTIVATE_CLASS.getMethod(name, new Class[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String[] getGroup(Annotation annotation) {
        if (GROUP_METHOD == null) {
            return null;
        }
        try {
            Object result = GROUP_METHOD.invoke((Object)annotation, new Object[0]);
            if (result instanceof String[]) {
                return (String[])result;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String[] getValue(Annotation annotation) {
        if (VALUE_METHOD == null) {
            return null;
        }
        try {
            Object result = VALUE_METHOD.invoke((Object)annotation, new Object[0]);
            if (result instanceof String[]) {
                return (String[])result;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String[] getBefore(Annotation annotation) {
        if (BEFORE_METHOD == null) {
            return null;
        }
        try {
            Object result = BEFORE_METHOD.invoke((Object)annotation, new Object[0]);
            if (result instanceof String[]) {
                return (String[])result;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String[] getAfter(Annotation annotation) {
        if (AFTER_METHOD == null) {
            return null;
        }
        try {
            Object result = AFTER_METHOD.invoke((Object)annotation, new Object[0]);
            if (result instanceof String[]) {
                return (String[])result;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static int getOrder(Annotation annotation) {
        if (ORDER_METHOD == null) {
            return 0;
        }
        try {
            Object result = ORDER_METHOD.invoke((Object)annotation, new Object[0]);
            if (result instanceof Integer) {
                return (Integer)result;
            }
            return 0;
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static String[] getOnClass(Annotation annotation) {
        if (ON_CLASS_METHOD == null) {
            return null;
        }
        try {
            Object result = ON_CLASS_METHOD.invoke((Object)annotation, new Object[0]);
            if (result instanceof String[]) {
                return (String[])result;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

