/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.ssl.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.ssl.AuthPolicy;
import org.apache.dubbo.common.ssl.Cert;
import org.apache.dubbo.common.ssl.CertProvider;
import org.apache.dubbo.common.ssl.ProviderCert;
import org.apache.dubbo.common.utils.IOUtils;

@Activate(order=2147473647)
public class SSLConfigCertProvider
implements CertProvider {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SSLConfigCertProvider.class);

    @Override
    public boolean isSupport(URL address) {
        return address.getOrDefaultApplicationModel().getApplicationConfigManager().getSsl().isPresent();
    }

    @Override
    public ProviderCert getProviderConnectionConfig(URL localAddress) {
        return localAddress.getOrDefaultApplicationModel().getApplicationConfigManager().getSsl().filter(sslConfig -> Objects.nonNull(sslConfig.getServerKeyCertChainPath())).filter(sslConfig -> Objects.nonNull(sslConfig.getServerPrivateKeyPath())).map(sslConfig -> {
            try {
                return new ProviderCert(IOUtils.toByteArray(sslConfig.getServerKeyCertChainPathStream()), IOUtils.toByteArray(sslConfig.getServerPrivateKeyPathStream()), sslConfig.getServerTrustCertCollectionPath() != null ? IOUtils.toByteArray(sslConfig.getServerTrustCertCollectionPathStream()) : null, sslConfig.getServerKeyPassword(), AuthPolicy.CLIENT_AUTH);
            }
            catch (IOException e) {
                this.logger.warn("5-41", "", "", "Failed to load ssl config.", e);
                return null;
            }
        }).orElse(null);
    }

    @Override
    public Cert getConsumerConnectionConfig(URL remoteAddress) {
        return remoteAddress.getOrDefaultApplicationModel().getApplicationConfigManager().getSsl().filter(sslConfig -> Objects.nonNull(sslConfig.getClientKeyCertChainPath())).filter(sslConfig -> Objects.nonNull(sslConfig.getClientPrivateKeyPath())).map(sslConfig -> {
            try {
                return new Cert(IOUtils.toByteArray(sslConfig.getClientKeyCertChainPathStream()), IOUtils.toByteArray(sslConfig.getClientPrivateKeyPathStream()), sslConfig.getClientTrustCertCollectionPath() != null ? IOUtils.toByteArray(sslConfig.getClientTrustCertCollectionPathStream()) : null, sslConfig.getClientKeyPassword());
            }
            catch (IOException e) {
                this.logger.warn("5-41", "", "", "Failed to load ssl config.", e);
                return null;
            }
        }).orElse(null);
    }
}

