/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class ConcurrentHashMapUtils {
    private static boolean IS_JAVA8;

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> func) {
        if (IS_JAVA8) {
            Object v = map.get(key);
            if (null == v) {
                v = map.computeIfAbsent((K)key, func);
            }
            return v;
        }
        return map.computeIfAbsent((K)key, func);
    }

    static {
        try {
            IS_JAVA8 = System.getProperty("java.version").startsWith("1.8.");
        }
        catch (Exception ignore) {
            IS_JAVA8 = true;
        }
    }
}

