/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.RegexProperties;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractReferenceConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class ReferenceConfigBase<T>
extends AbstractReferenceConfig {
    private static final long serialVersionUID = -5864351140409987595L;
    private static final String ORIGIN_CONFIG = "ORIGIN_CONFIG";
    protected Class<?> interfaceClass;
    protected String url;
    protected ConsumerConfig consumer;
    protected Boolean unloadClusterRelated;

    public ReferenceConfigBase() {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute(ORIGIN_CONFIG, this);
    }

    public ReferenceConfigBase(ModuleModel moduleModel) {
        super(moduleModel);
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute(ORIGIN_CONFIG, this);
    }

    public ReferenceConfigBase(Reference reference) {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute(ORIGIN_CONFIG, this);
        this.appendAnnotation(Reference.class, reference);
        this.setMethods(MethodConfig.constructMethodConfig(reference.methods()));
    }

    public ReferenceConfigBase(ModuleModel moduleModel, Reference reference) {
        super(moduleModel);
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute(ORIGIN_CONFIG, this);
        this.appendAnnotation(Reference.class, reference);
        this.setMethods(MethodConfig.constructMethodConfig(reference.methods()));
    }

    public boolean shouldCheck() {
        this.checkDefault();
        Boolean shouldCheck = this.isCheck();
        if (shouldCheck == null && this.getConsumer() != null) {
            shouldCheck = this.getConsumer().isCheck();
        }
        if (shouldCheck == null) {
            shouldCheck = true;
        }
        return shouldCheck;
    }

    public boolean shouldInit() {
        this.checkDefault();
        Boolean shouldInit = this.isInit();
        if (shouldInit == null && this.getConsumer() != null) {
            shouldInit = this.getConsumer().isInit();
        }
        if (shouldInit == null) {
            return true;
        }
        return shouldInit;
    }

    @Override
    protected void preProcessRefresh() {
        super.preProcessRefresh();
        if (this.consumer == null) {
            this.consumer = this.getModuleConfigManager().getDefaultConsumer().orElseThrow(() -> new IllegalStateException("Default consumer is not initialized"));
        }
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public List<String> getPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("dubbo.reference." + this.interfaceName);
        return prefixes;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.getMetaData(null);
    }

    @Override
    public Map<String, String> getMetaData(String prefix) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        ConsumerConfig consumer = this.getConsumer();
        if (this.isRefreshed() && consumer == null) {
            throw new IllegalStateException("Consumer is not initialized");
        }
        ReferenceConfigBase.appendAttributes(metaData, consumer, prefix);
        ReferenceConfigBase.appendAttributes(metaData, this, prefix);
        return metaData;
    }

    public Class<?> getServiceInterfaceClass() {
        Class<?> actualInterface = this.interfaceClass;
        if (this.interfaceClass == GenericService.class) {
            try {
                actualInterface = this.getInterfaceClassLoader() != null ? Class.forName(this.interfaceName, false, this.getInterfaceClassLoader()) : Class.forName(this.interfaceName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return actualInterface;
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        String generic = this.getGeneric();
        if (StringUtils.isBlank(generic) && this.getConsumer() != null) {
            generic = this.getConsumer().getGeneric();
        }
        this.interfaceClass = this.getInterfaceClassLoader() != null ? ReferenceConfigBase.determineInterfaceClass(generic, this.interfaceName, this.getInterfaceClassLoader()) : ReferenceConfigBase.determineInterfaceClass(generic, this.interfaceName);
        return this.interfaceClass;
    }

    public static Class<?> determineInterfaceClass(String generic, String interfaceName) {
        return ReferenceConfigBase.determineInterfaceClass(generic, interfaceName, ClassUtils.getClassLoader());
    }

    public static Class<?> determineInterfaceClass(String generic, String interfaceName, ClassLoader classLoader) {
        if (ProtocolUtils.isGeneric(generic)) {
            return GenericService.class;
        }
        try {
            if (StringUtils.isNotEmpty(interfaceName)) {
                return Class.forName(interfaceName, true, classLoader);
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return null;
    }

    @Override
    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
        super.postProcessAfterScopeModelChanged(oldScopeModel, newScopeModel);
        if (this.consumer != null && this.consumer.getScopeModel() != this.scopeModel) {
            this.consumer.setScopeModel(this.scopeModel);
        }
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.setInterface(interfaceClass == null ? null : interfaceClass.getName());
        this.interfaceClass = interfaceClass;
        this.setInterfaceClassLoader(interfaceClass == null ? null : interfaceClass.getClassLoader());
    }

    @Parameter(excluded=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ConsumerConfig getConsumer() {
        return this.consumer;
    }

    public void setConsumer(ConsumerConfig consumer) {
        this.consumer = consumer;
    }

    @Parameter(key="unloadClusterRelated")
    public Boolean getUnloadClusterRelated() {
        return this.unloadClusterRelated;
    }

    public void setUnloadClusterRelated(Boolean unloadClusterRelated) {
        this.unloadClusterRelated = unloadClusterRelated;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    protected void resolveFile() {
        String resolve = System.getProperty(this.interfaceName);
        String resolveFile = null;
        if (StringUtils.isEmpty(resolve)) {
            File userResolveFile;
            resolveFile = System.getProperty("dubbo.resolve.file");
            if (StringUtils.isEmpty(resolveFile) && (userResolveFile = new File(new File(System.getProperty("user.home")), "dubbo-resolve.properties")).exists()) {
                resolveFile = userResolveFile.getAbsolutePath();
            }
            if (resolveFile != null && resolveFile.length() > 0) {
                RegexProperties properties = new RegexProperties();
                try (FileInputStream fis = new FileInputStream(resolveFile);){
                    properties.load(fis);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load " + resolveFile + ", cause: " + e.getMessage(), e);
                }
                resolve = ((Properties)properties).getProperty(this.interfaceName);
            }
        }
        if (StringUtils.isNotEmpty(resolve)) {
            this.url = resolve;
            if (logger.isWarnEnabled()) {
                if (resolveFile != null) {
                    logger.warn("0-12", "", "", "Using default dubbo resolve file " + resolveFile + " replace " + this.interfaceName + "" + resolve + " to p2p invoke remote service.");
                } else {
                    logger.warn("0-12", "", "", "Using -D" + this.interfaceName + "=" + resolve + " to p2p invoke remote service.");
                }
            }
        }
    }

    @Override
    protected void computeValidRegistryIds() {
        if (this.consumer != null && this.notHasSelfRegistryProperty()) {
            this.setRegistries(this.consumer.getRegistries());
            this.setRegistryIds(this.consumer.getRegistryIds());
        }
        super.computeValidRegistryIds();
    }

    @Parameter(excluded=true, attribute=false)
    public String getUniqueServiceName() {
        return this.interfaceName != null ? URL.buildKey(this.interfaceName, this.getGroup(), this.getVersion()) : null;
    }

    @Override
    public String getVersion() {
        return StringUtils.isEmpty(this.version) ? (this.consumer != null ? this.consumer.getVersion() : this.version) : this.version;
    }

    @Override
    public String getGroup() {
        return StringUtils.isEmpty(this.group) ? (this.consumer != null ? this.consumer.getGroup() : this.group) : this.group;
    }

    public Boolean shouldReferAsync() {
        Boolean shouldReferAsync = this.getReferAsync();
        if (shouldReferAsync == null) {
            shouldReferAsync = this.consumer != null && this.consumer.getReferAsync() != null && this.consumer.getReferAsync() != false;
        }
        return shouldReferAsync;
    }

    public abstract T get();

    public void destroy() {
        this.getModuleConfigManager().removeConfig(this);
    }
}

