/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.status.reporter;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Set;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.reporter.FrameworkStatusReporter;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class FrameworkStatusReportService
implements ScopeModelAware {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkStatusReporter.class);
    public static final String REGISTRATION_STATUS = "registration";
    public static final String ADDRESS_CONSUMPTION_STATUS = "consumption";
    public static final String MIGRATION_STEP_STATUS = "migrationStepStatus";
    private ApplicationModel applicationModel;
    private Set<FrameworkStatusReporter> reporters;
    private Gson gson = new Gson();

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.reporters = applicationModel.getExtensionLoader(FrameworkStatusReporter.class).getSupportedExtensionInstances();
    }

    public void reportRegistrationStatus(Object obj) {
        this.doReport(REGISTRATION_STATUS, obj);
    }

    public void reportConsumptionStatus(Object obj) {
        this.doReport(ADDRESS_CONSUMPTION_STATUS, obj);
    }

    public void reportMigrationStepStatus(Object obj) {
        this.doReport(MIGRATION_STEP_STATUS, obj);
    }

    public boolean hasReporter() {
        return this.reporters.size() > 0;
    }

    private void doReport(String type, Object obj) {
        try {
            if (CollectionUtils.isNotEmpty(this.reporters)) {
                for (FrameworkStatusReporter reporter : this.reporters) {
                    reporter.report(type, obj);
                }
            }
        }
        catch (Exception e) {
            logger.info("Report " + type + " status failed because of " + e.getMessage());
        }
    }

    public String createRegistrationReport(String status) {
        HashMap<String, String> registration = new HashMap<String, String>();
        registration.put("application", this.applicationModel.getApplicationName());
        registration.put("status", status);
        return this.gson.toJson(registration);
    }

    public String createConsumptionReport(String interfaceName, String version, String group, String status) {
        HashMap<String, String> migrationStatus = new HashMap<String, String>();
        migrationStatus.put("type", ADDRESS_CONSUMPTION_STATUS);
        migrationStatus.put("application", this.applicationModel.getApplicationName());
        migrationStatus.put("service", interfaceName);
        migrationStatus.put("version", version);
        migrationStatus.put("group", group);
        migrationStatus.put("status", status);
        return this.gson.toJson(migrationStatus);
    }

    public String createMigrationStepReport(String interfaceName, String version, String group, String originStep, String newStep, String success) {
        HashMap<String, String> migrationStatus = new HashMap<String, String>();
        migrationStatus.put("type", MIGRATION_STEP_STATUS);
        migrationStatus.put("application", this.applicationModel.getApplicationName());
        migrationStatus.put("service", interfaceName);
        migrationStatus.put("version", version);
        migrationStatus.put("group", group);
        migrationStatus.put("originStep", originStep);
        migrationStatus.put("newStep", newStep);
        migrationStatus.put("success", success);
        return this.gson.toJson(migrationStatus);
    }
}

