/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.convert;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.convert.Converter;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class ConverterUtil {
    private final FrameworkModel frameworkModel;
    private final Map<Class<?>, Map<Class<?>, List<Converter>>> converterCache = new ConcurrentHashMap();

    public ConverterUtil(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public Converter<?, ?> getConverter(Class<?> sourceType, Class<?> targetType) {
        Map toTargetMap = this.converterCache.computeIfAbsent(sourceType, k -> new ConcurrentHashMap());
        List converters = toTargetMap.computeIfAbsent(targetType, k -> this.frameworkModel.getExtensionLoader(Converter.class).getSupportedExtensionInstances().stream().filter(converter -> converter.accept(sourceType, targetType)).collect(Collectors.toList()));
        return converters.size() > 0 ? (Converter)converters.get(0) : null;
    }

    public <T> T convertIfPossible(Object source, Class<T> targetType) {
        Converter<?, ?> converter = this.getConverter(source.getClass(), targetType);
        if (converter != null) {
            return (T)converter.convert(source);
        }
        return null;
    }
}

