/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.utils.StringUtils;

public abstract class AbstractPrefixConfiguration
implements Configuration {
    protected String id;
    protected String prefix;

    public AbstractPrefixConfiguration(String prefix, String id) {
        this.prefix = StringUtils.isNotEmpty(prefix) && !prefix.endsWith(".") ? prefix + "." : prefix;
        this.id = id;
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = null;
        if (StringUtils.isNotEmpty(this.prefix) && StringUtils.isNotEmpty(this.id)) {
            value = this.getInternalProperty(this.prefix + this.id + "." + key);
        }
        if (value == null && StringUtils.isNotEmpty(this.prefix)) {
            value = this.getInternalProperty(this.prefix + key);
        }
        if (value == null) {
            value = this.getInternalProperty(key);
        }
        return value != null ? value : defaultValue;
    }
}

