/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.DubboMethodArg;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.StringMatch;

public class DubboMethodMatch {
    private StringMatch name_match;
    private Integer argc;
    private List<DubboMethodArg> args;
    private List<StringMatch> argp;
    private Map<String, StringMatch> headers;

    public StringMatch getName_match() {
        return this.name_match;
    }

    public void setName_match(StringMatch name_match) {
        this.name_match = name_match;
    }

    public Integer getArgc() {
        return this.argc;
    }

    public void setArgc(Integer argc) {
        this.argc = argc;
    }

    public List<DubboMethodArg> getArgs() {
        return this.args;
    }

    public void setArgs(List<DubboMethodArg> args) {
        this.args = args;
    }

    public List<StringMatch> getArgp() {
        return this.argp;
    }

    public void setArgp(List<StringMatch> argp) {
        this.argp = argp;
    }

    public Map<String, StringMatch> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, StringMatch> headers) {
        this.headers = headers;
    }

    public String toString() {
        return "DubboMethodMatch{name_match=" + this.name_match + ", argc=" + this.argc + ", args=" + this.args + ", argp=" + this.argp + ", headers=" + this.headers + '}';
    }

    public boolean isMatch(Invocation invocation) {
        List<DubboMethodArg> args;
        StringMatch nameMatch = this.getName_match();
        if (nameMatch != null && !nameMatch.isMatch(invocation.getMethodName())) {
            return false;
        }
        Integer argc = this.getArgc();
        Object[] arguments = invocation.getArguments();
        if (argc != null && (argc != 0 && (arguments == null || arguments.length == 0) || argc != arguments.length)) {
            return false;
        }
        List<StringMatch> argp = this.getArgp();
        Class[] parameterTypes = invocation.getParameterTypes();
        if (argp != null && argp.size() > 0) {
            if (parameterTypes == null || parameterTypes.length == 0) {
                return false;
            }
            if (argp.size() != parameterTypes.length) {
                return false;
            }
            for (int index = 0; index < argp.size(); ++index) {
                boolean match;
                boolean bl = match = argp.get(index).isMatch(parameterTypes[index].getName()) || argp.get(index).isMatch(parameterTypes[index].getSimpleName());
                if (match) continue;
                return false;
            }
        }
        if ((args = this.getArgs()) != null && args.size() > 0) {
            if (arguments == null || arguments.length == 0) {
                return false;
            }
            for (DubboMethodArg dubboMethodArg : args) {
                int index = dubboMethodArg.getIndex();
                if (index >= arguments.length) {
                    throw new IndexOutOfBoundsException("DubboMethodArg index >= parameters.length");
                }
                if (dubboMethodArg.isMatch(arguments[index])) continue;
                return false;
            }
        }
        return true;
    }
}

