/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.AbstractSpringArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Helper;

@Activate(onClass={"org.springframework.web.bind.annotation.RequestPart"})
public class RequestPartArgumentResolver
extends AbstractSpringArgumentResolver {
    @Override
    public Class<Annotation> accept() {
        return Annotations.RequestPart.type();
    }

    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param, AnnotationMeta<Annotation> ann) {
        return new NamedValueMeta(ann.getValue(), Helper.isRequired(ann), null);
    }

    @Override
    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return request.part(meta.name());
    }

    @Override
    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return meta.type() == byte[].class ? request.part(meta.name()) : request.parts();
    }

    @Override
    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Collection<HttpRequest.FileUpload> parts = request.parts();
        if (parts.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, HttpRequest.FileUpload> result = new LinkedHashMap<String, HttpRequest.FileUpload>(parts.size());
        for (HttpRequest.FileUpload part : parts) {
            result.put(part.name(), part);
        }
        return result;
    }
}

