/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestParameterException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AnnotationBaseArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate(onClass={"org.springframework.web.bind.annotation.PathVariable"})
public class PathVariableArgumentResolver
implements AnnotationBaseArgumentResolver<Annotation> {
    @Override
    public Class<Annotation> accept() {
        return Annotations.PathVariable.type();
    }

    @Override
    public Object resolve(ParameterMeta parameter, AnnotationMeta<Annotation> annotation, HttpRequest request, HttpResponse response) {
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        String name = annotation.getValue();
        if (StringUtils.isEmpty(name)) {
            name = parameter.getRequiredName();
        }
        if (variableMap == null) {
            if (Helper.isRequired(annotation)) {
                throw new RestParameterException(Messages.ARGUMENT_VALUE_MISSING, name, parameter.getType());
            }
            return null;
        }
        String value = (String)variableMap.get(name);
        if (value == null) {
            return null;
        }
        int index = value.indexOf(59);
        return RequestUtils.decodeURL(index == -1 ? value : value.substring(0, index));
    }
}

