/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;

final class BeanArgumentBinder {
    private static final Map<Class<?>, BeanMeta.ConstructorMeta> CACHE = CollectionUtils.newConcurrentHashMap();
    private final ArgumentResolver argumentResolver;
    private final ConversionService conversionService;

    BeanArgumentBinder(FrameworkModel frameworkModel, ConversionService conversionService) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.argumentResolver = beanFactory.getOrRegisterBean(CompositeArgumentResolver.class);
        this.conversionService = conversionService;
    }

    public Object bind(ParameterMeta paramMeta, HttpRequest request, HttpResponse response) {
        String name = StringUtils.defaultIf(paramMeta.getName(), "target");
        try {
            Object bean = this.createBean(paramMeta, request, response);
            WebDataBinder binder = new WebDataBinder(bean, name);
            binder.setConversionService(this.conversionService);
            binder.bind((PropertyValues)new MutablePropertyValues(RequestUtils.getParametersMap(request)));
            BindingResult result = binder.getBindingResult();
            if (result.hasErrors()) {
                throw new BindException(result);
            }
            return binder.getTarget();
        }
        catch (Exception e) {
            throw new RestException(e, Messages.ARGUMENT_BIND_ERROR, name, paramMeta.getType());
        }
    }

    private Object createBean(ParameterMeta paramMeta, HttpRequest request, HttpResponse response) {
        Class<?> type = paramMeta.getActualType();
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalStateException(Messages.ARGUMENT_COULD_NOT_RESOLVED.format(paramMeta.getDescription()));
        }
        BeanMeta.ConstructorMeta ct = CACHE.computeIfAbsent(type, k -> BeanMeta.resolveConstructor(paramMeta.getToolKit(), null, type));
        BeanMeta.ConstructorParameterMeta[] parameters = ct.getParameters();
        int len = parameters.length;
        if (len == 0) {
            return ct.newInstance(new Object[0]);
        }
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            BeanMeta.ConstructorParameterMeta parameter = parameters[i];
            args[i] = parameter.isSimple() ? this.argumentResolver.resolve(parameter, request, response) : null;
        }
        return ct.newInstance(args);
    }
}

