/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.filter;

import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.AbstractRestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtensionAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(onClass={"javax.ws.rs.ext.ExceptionMapper"})
public final class ExceptionMapperAdapter
implements RestExtensionAdapter<ExceptionMapper<Throwable>> {
    @Override
    public boolean accept(Object extension) {
        return extension instanceof ExceptionMapper;
    }

    @Override
    public RestFilter adapt(ExceptionMapper<Throwable> extension) {
        return new Filter(extension);
    }

    private static final class Filter
    extends AbstractRestFilter<ExceptionMapper<Throwable>>
    implements RestFilter.Listener {
        private final Class<?> exceptionType;

        public Filter(ExceptionMapper<Throwable> extension) {
            super(extension);
            this.exceptionType = Objects.requireNonNull(TypeUtils.getSuperGenericType(extension.getClass()));
        }

        @Override
        public void onResponse(Result result, HttpRequest request, HttpResponse response) throws Exception {
            Throwable t;
            if (result.hasException() && this.exceptionType.isInstance(t = result.getException())) {
                try (Response r = ((ExceptionMapper)this.extension).toResponse(t);){
                    response.setBody(Helper.toBody(r));
                }
            }
        }

        @Override
        public void onError(Throwable t, HttpRequest request, HttpResponse response) {
            if (this.exceptionType.isInstance(t)) {
                try (Response r = ((ExceptionMapper)this.extension).toResponse(t);){
                    response.setBody(Helper.toBody(r));
                }
            }
        }
    }
}

