/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.cors.CorsUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.JaxrsRestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

@Activate(onClass={"javax.ws.rs.Path"})
public class JaxrsRequestMappingResolver
implements RequestMappingResolver {
    private final FrameworkModel frameworkModel;
    private final RestToolKit toolKit;
    private CorsMeta globalCorsMeta;

    public JaxrsRequestMappingResolver(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.toolKit = new JaxrsRestToolKit(frameworkModel);
    }

    @Override
    public RestToolKit getRestToolKit() {
        return this.toolKit;
    }

    @Override
    public RequestMapping resolve(ServiceMeta serviceMeta) {
        AnnotationMeta path = serviceMeta.findAnnotation(Annotations.Path);
        if (path == null) {
            return null;
        }
        return this.builder(serviceMeta, path, null).name(serviceMeta.getType().getSimpleName()).contextPath(serviceMeta.getContextPath()).build();
    }

    @Override
    public RequestMapping resolve(MethodMeta methodMeta) {
        AnnotationMeta path = methodMeta.findAnnotation(Annotations.Path);
        if (path == null) {
            return null;
        }
        AnnotationMeta httpMethod = methodMeta.findMergedAnnotation(Annotations.HttpMethod);
        if (httpMethod == null) {
            return null;
        }
        ServiceMeta serviceMeta = methodMeta.getServiceMeta();
        if (this.globalCorsMeta == null) {
            this.globalCorsMeta = CorsUtils.getGlobalCorsMeta(this.frameworkModel);
        }
        return this.builder(methodMeta, path, httpMethod).name(methodMeta.getMethod().getName()).contextPath(methodMeta.getServiceMeta().getContextPath()).service(serviceMeta.getServiceGroup(), serviceMeta.getServiceVersion()).cors(this.globalCorsMeta).build();
    }

    private RequestMapping.Builder builder(AnnotationSupport meta, AnnotationMeta<?> path, AnnotationMeta<?> httpMethod) {
        AnnotationMeta consumes;
        AnnotationMeta produces;
        RequestMapping.Builder builder = RequestMapping.builder().path(path.getValue());
        if (httpMethod == null) {
            httpMethod = meta.findMergedAnnotation(Annotations.HttpMethod);
        }
        if (httpMethod != null) {
            builder.method(httpMethod.getValue());
        }
        if ((produces = meta.findAnnotation(Annotations.Produces)) != null) {
            builder.produce(produces.getValueArray());
        }
        if ((consumes = meta.findAnnotation(Annotations.Consumes)) != null) {
            builder.consume(consumes.getValueArray());
        }
        return builder;
    }
}

