/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.annotation.Annotation;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.AbstractJaxrsArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;

@Activate(onClass={"javax.ws.rs.FormParam"})
public class FormParamArgumentResolver
extends AbstractJaxrsArgumentResolver {
    @Override
    public Class<Annotation> accept() {
        return Annotations.FormParam.type();
    }

    @Override
    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return CollectionUtils.first(request.formParameterValues(this.getFullName(meta)));
    }

    @Override
    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return request.formParameterValues(this.getFullName(meta));
    }

    private String getFullName(NamedValueMeta meta) {
        String prefix = meta.parameterMeta().getPrefix();
        return prefix == null ? meta.name() : prefix + '.' + meta.name();
    }
}

