/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.io.IOException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AbstractArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(order=2147473647, onClass={"javax.ws.rs.Path"})
public class FallbackArgumentResolver
extends AbstractArgumentResolver {
    @Override
    public boolean accept(ParameterMeta param) {
        return param.getToolKit().getDialect() == 2;
    }

    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param) {
        return new NamedValueMeta(param.isAnnotated(Annotations.Nonnull), Helper.defaultValue(param));
    }

    @Override
    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Object value = RequestUtils.decodeBody(request, meta.genericType());
        if (value != null) {
            return value;
        }
        if (meta.parameterMeta().isSimple()) {
            return request.parameter(meta.name());
        }
        return null;
    }

    @Override
    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Class<?> type = meta.type();
        if (type == byte[].class) {
            try {
                return StreamUtils.readBytes(request.inputStream());
            }
            catch (IOException e) {
                throw new RestException(e);
            }
        }
        Object value = RequestUtils.decodeBody(request, meta.genericType());
        if (value != null) {
            return value;
        }
        if (TypeUtils.isSimpleProperty(meta.nestedType(0))) {
            return request.parameterValues(meta.name());
        }
        return null;
    }

    @Override
    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Object value = RequestUtils.decodeBody(request, meta.genericType());
        if (value != null) {
            return value;
        }
        if (TypeUtils.isSimpleProperty(meta.nestedType(1))) {
            return RequestUtils.getParametersMap(request);
        }
        return null;
    }
}

