/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class MethodMeta
extends AnnotationSupport {
    private final List<Method> hierarchy;
    private final Method method;
    private MethodDescriptor methodDescriptor;
    private ParameterMeta[] parameters;
    private final ServiceMeta serviceMeta;

    public MethodMeta(List<Method> hierarchy, MethodDescriptor methodDescriptor, ServiceMeta serviceMeta) {
        super(serviceMeta.getToolKit());
        this.hierarchy = hierarchy;
        this.method = this.initMethod(hierarchy, methodDescriptor);
        this.methodDescriptor = methodDescriptor;
        this.serviceMeta = serviceMeta;
    }

    private Method initMethod(List<Method> hierarchy, MethodDescriptor methodDescriptor) {
        Method method = null;
        if (methodDescriptor != null) {
            method = methodDescriptor.getMethod();
        }
        return method == null ? hierarchy.get(hierarchy.size() - 1) : method;
    }

    public void initParameters() {
        MethodDescriptor.RpcType rpcType = this.methodDescriptor.getRpcType();
        if (rpcType == MethodDescriptor.RpcType.CLIENT_STREAM || rpcType == MethodDescriptor.RpcType.BI_STREAM) {
            Type genericType = TypeUtils.getNestedGenericType(this.method.getGenericReturnType(), 0);
            this.parameters = new ParameterMeta[]{new StreamParameterMeta(this.getToolKit(), genericType, this.method, this.hierarchy)};
            return;
        }
        int count = rpcType == MethodDescriptor.RpcType.SERVER_STREAM ? 1 : this.method.getParameterCount();
        ArrayList parameterHierarchies = new ArrayList(count);
        int size = this.hierarchy.size();
        for (int i = 0; i < size; ++i) {
            Method m = this.hierarchy.get(i);
            Parameter[] mps = m.getParameters();
            for (int j = 0; j < count; ++j) {
                List<Parameter> parameterHierarchy;
                if (parameterHierarchies.size() <= j) {
                    parameterHierarchy = new ArrayList(size);
                    parameterHierarchies.add(parameterHierarchy);
                } else {
                    parameterHierarchy = (List)parameterHierarchies.get(j);
                }
                parameterHierarchy.add(mps[j]);
            }
        }
        String[] parameterNames = this.getToolKit().getParameterNames(this.method);
        ParameterMeta[] parameters = new ParameterMeta[count];
        for (int i = 0; i < count; ++i) {
            String parameterName = parameterNames == null ? null : parameterNames[i];
            parameters[i] = new MethodParameterMeta((List)parameterHierarchies.get(i), parameterName, i, this);
        }
        this.parameters = parameters;
    }

    public List<Method> getHierarchy() {
        return this.hierarchy;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public ParameterMeta[] getParameters() {
        return this.parameters;
    }

    public ServiceMeta getServiceMeta() {
        return this.serviceMeta;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    @Override
    protected List<? extends AnnotatedElement> getAnnotatedElements() {
        return this.hierarchy;
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.method;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != MethodMeta.class) {
            return false;
        }
        return this.method.equals(((MethodMeta)obj).method);
    }

    public String toString() {
        return "MethodMeta{method=" + this.toShortString() + ", service=" + this.serviceMeta.toShortString() + '}';
    }

    public String toShortString() {
        return MethodUtils.toShortString(this.method);
    }

    private static final class StreamParameterMeta
    extends ParameterMeta {
        private final Class<?> type;
        private final Type genericType;
        private final AnnotatedElement element;
        private final List<? extends AnnotatedElement> elements;

        StreamParameterMeta(RestToolKit toolKit, Type genericType, AnnotatedElement element, List<? extends AnnotatedElement> elements) {
            super(toolKit, "value");
            this.type = TypeUtils.getActualType(genericType);
            this.genericType = genericType;
            this.element = element;
            this.elements = elements;
        }

        @Override
        public String getDescription() {
            return "Stream parameter [" + this.element + "]";
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public Type getGenericType() {
            return this.genericType;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return this.element;
        }

        @Override
        protected List<? extends AnnotatedElement> getAnnotatedElements() {
            return this.elements;
        }
    }
}

