/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.dubbo.remoting.http12.rest.Param;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class BeanMeta {
    private final Map<String, FieldMeta> fields = new LinkedHashMap<String, FieldMeta>();
    private final Map<String, SetMethodMeta> methods = new LinkedHashMap<String, SetMethodMeta>();
    private final ConstructorMeta constructor;

    public BeanMeta(RestToolKit toolKit, String prefix, Class<?> type) {
        this.constructor = BeanMeta.resolveConstructor(toolKit, prefix, type);
        this.resolveFieldAndMethod(toolKit, prefix, type);
    }

    public BeanMeta(RestToolKit toolKit, Class<?> type) {
        this(toolKit, null, type);
    }

    public Collection<FieldMeta> getFields() {
        return this.fields.values();
    }

    public FieldMeta getField(String name) {
        return this.fields.get(name);
    }

    public Collection<SetMethodMeta> getMethods() {
        return this.methods.values();
    }

    public SetMethodMeta getMethod(String name) {
        return this.methods.get(name);
    }

    public ConstructorMeta getConstructor() {
        return this.constructor;
    }

    public Object newInstance() {
        return this.constructor.newInstance(new Object[0]);
    }

    public static ConstructorMeta resolveConstructor(RestToolKit toolKit, String prefix, Class<?> type) {
        Constructor<?>[] constructors = type.getConstructors();
        Constructor<?> ct = null;
        if (constructors.length == 1) {
            ct = constructors[0];
        } else {
            try {
                ct = type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (ct == null) {
            throw new IllegalArgumentException("No available default constructor found in " + type);
        }
        return new ConstructorMeta(toolKit, prefix, ct);
    }

    private void resolveFieldAndMethod(RestToolKit toolKit, String prefix, Class<?> type) {
        int modifiers;
        if (type == Object.class) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || field.getAnnotations().length == 0) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            FieldMeta fieldMeta = new FieldMeta(toolKit, prefix, field);
            this.fields.put(fieldMeta.getName(), fieldMeta);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (((Method)accessibleObject).getParameterCount() != 1 || ((modifiers = ((Method)accessibleObject).getModifiers()) & 0x409) != 1) continue;
            Parameter parameter = ((Executable)accessibleObject).getParameters()[0];
            String name = ((Method)accessibleObject).getName();
            if (name.length() <= 3 || !name.startsWith("set")) continue;
            String getMethodName = "get" + name.substring(3);
            Method getMethod = null;
            try {
                getMethod = type.getDeclaredMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            SetMethodMeta methodMeta = new SetMethodMeta(toolKit, (Method)accessibleObject, getMethod, parameter, prefix, name);
            this.methods.put(methodMeta.getName(), methodMeta);
        }
        this.resolveFieldAndMethod(toolKit, prefix, type.getSuperclass());
    }

    public static final class ConstructorMeta {
        private final Constructor<?> constructor;
        private final ConstructorParameterMeta[] parameters;

        ConstructorMeta(RestToolKit toolKit, String prefix, Constructor<?> constructor) {
            this.constructor = constructor;
            this.parameters = this.initParameters(toolKit, prefix, constructor);
        }

        public ConstructorParameterMeta[] getParameters() {
            return this.parameters;
        }

        private ConstructorParameterMeta[] initParameters(RestToolKit toolKit, String prefix, Constructor<?> ct) {
            Parameter[] cps = ct.getParameters();
            int len = cps.length;
            ConstructorParameterMeta[] parameters = new ConstructorParameterMeta[len];
            for (int i = 0; i < len; ++i) {
                parameters[i] = new ConstructorParameterMeta(toolKit, cps[i], prefix);
            }
            return parameters;
        }

        public Object newInstance(Object ... args) {
            try {
                return this.constructor.newInstance(args);
            }
            catch (Throwable t) {
                throw ExceptionUtils.wrap(t);
            }
        }
    }

    public static final class FieldMeta
    extends NestableParameterMeta {
        private final Field field;

        FieldMeta(RestToolKit toolKit, String prefix, Field field) {
            super(toolKit, prefix, field.getName());
            this.field = field;
            this.initNestedMeta();
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Type getGenericType() {
            return this.field.getGenericType();
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return this.field;
        }

        @Override
        public void setValue(Object bean, Object value) {
            try {
                this.field.set(bean, value);
            }
            catch (Throwable t) {
                throw ExceptionUtils.wrap(t);
            }
        }

        @Override
        public Object getValue(Object bean) {
            try {
                return this.field.get(bean);
            }
            catch (Throwable t) {
                throw ExceptionUtils.wrap(t);
            }
        }

        @Override
        public String getDescription() {
            return "FieldParameter{" + this.field + '}';
        }
    }

    public static final class SetMethodMeta
    extends NestableParameterMeta {
        private final Method method;
        private final Method getMethod;
        private final Parameter parameter;

        SetMethodMeta(RestToolKit toolKit, Method m, Method gm, Parameter p, String prefix, String name) {
            super(toolKit, prefix, name);
            this.method = m;
            this.getMethod = gm;
            this.parameter = p;
            this.initNestedMeta();
        }

        @Override
        public Class<?> getType() {
            return this.parameter.getType();
        }

        @Override
        public Type getGenericType() {
            return this.parameter.getParameterizedType();
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return this.parameter;
        }

        @Override
        public void setValue(Object bean, Object value) {
            try {
                this.method.invoke(bean, value);
            }
            catch (Throwable t) {
                throw ExceptionUtils.wrap(t);
            }
        }

        @Override
        public Object getValue(Object bean) {
            if (this.getMethod == null) {
                return null;
            }
            try {
                return this.getMethod.invoke(bean, new Object[0]);
            }
            catch (Throwable t) {
                throw ExceptionUtils.wrap(t);
            }
        }

        @Override
        public String getDescription() {
            return "SetMethodParameter{" + this.method + '}';
        }
    }

    private static final class NestedMeta
    extends NestableParameterMeta {
        private final Class<?> type;
        private final Type genericType;

        NestedMeta(RestToolKit toolKit, Type genericType) {
            super(toolKit, null, null);
            this.type = TypeUtils.getActualType(genericType);
            this.genericType = genericType;
            this.initNestedMeta();
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public Type getGenericType() {
            return this.genericType;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return null;
        }

        @Override
        public String getDescription() {
            return "NestedParameter{" + (this.genericType == null ? this.type : this.genericType) + '}';
        }
    }

    public static abstract class NestableParameterMeta
    extends ParameterMeta {
        private NestableParameterMeta nestedMeta;
        private String finalName;

        public NestableParameterMeta(RestToolKit toolKit, String prefix, String name) {
            super(toolKit, prefix, name);
        }

        @Override
        @Nullable
        public final String getName() {
            String name = this.finalName;
            if (name == null) {
                AnnotationMeta<Param> param = this.findAnnotation(Param.class);
                if (param != null) {
                    name = param.getValue();
                }
                if (name == null || name.isEmpty()) {
                    name = super.getName();
                }
                this.finalName = name;
            }
            return name;
        }

        public void setValue(Object bean, Object value) {
        }

        public Object getValue(Object bean) {
            return null;
        }

        public final NestableParameterMeta getNestedMeta() {
            return this.nestedMeta;
        }

        protected final void initNestedMeta() {
            Type nestedType = null;
            Class<?> type = this.getType();
            if (Map.class.isAssignableFrom(type)) {
                nestedType = TypeUtils.getNestedGenericType(this.getGenericType(), 1);
            } else if (Collection.class.isAssignableFrom(type)) {
                nestedType = TypeUtils.getNestedGenericType(this.getGenericType(), 0);
            } else if (type.isArray()) {
                Type genericType = this.getGenericType();
                nestedType = genericType instanceof GenericArrayType ? ((GenericArrayType)genericType).getGenericComponentType() : type.getComponentType();
            }
            this.nestedMeta = nestedType == null ? null : new NestedMeta(this.getToolKit(), nestedType);
        }
    }

    public static final class ConstructorParameterMeta
    extends ParameterMeta {
        private final Parameter parameter;

        ConstructorParameterMeta(RestToolKit toolKit, Parameter parameter, String prefix) {
            super(toolKit, prefix, parameter.isNamePresent() ? parameter.getName() : null);
            this.parameter = parameter;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return this.parameter;
        }

        @Override
        public Class<?> getType() {
            return this.parameter.getType();
        }

        @Override
        public Type getGenericType() {
            return this.parameter.getParameterizedType();
        }

        @Override
        public String getDescription() {
            return "ConstructorParameter{" + this.parameter + '}';
        }
    }
}

