/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.MediaTypeExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.NameValueExpression;

public final class ProducesCondition
implements Condition<ProducesCondition, HttpRequest> {
    private final List<MediaTypeExpression> expressions;

    public ProducesCondition(String ... produces) {
        this(produces, (String[])null);
    }

    public ProducesCondition(String[] produces, String[] headers) {
        LinkedHashSet<MediaTypeExpression> expressions = null;
        if (headers != null) {
            for (String header : headers) {
                MediaTypeExpression expression;
                NameValueExpression expr = NameValueExpression.parse(header);
                if (!HttpHeaderNames.ACCEPT.getName().equalsIgnoreCase(expr.getName()) || (expression = MediaTypeExpression.parse(expr.getValue())) == null) continue;
                if (expressions == null) {
                    expressions = new LinkedHashSet();
                }
                expressions.add(expression);
            }
        }
        if (produces != null) {
            for (String produce : produces) {
                MediaTypeExpression expression = MediaTypeExpression.parse(produce);
                if (expression == null) continue;
                if (expressions == null) {
                    expressions = new LinkedHashSet<MediaTypeExpression>();
                }
                expressions.add(expression);
            }
        }
        if (expressions == null) {
            this.expressions = Collections.emptyList();
        } else {
            this.expressions = new ArrayList<MediaTypeExpression>(expressions);
            Collections.sort(this.expressions);
        }
    }

    private ProducesCondition(List<MediaTypeExpression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public ProducesCondition combine(ProducesCondition other) {
        return other.expressions.isEmpty() ? this : other;
    }

    @Override
    public ProducesCondition match(HttpRequest request) {
        if (this.expressions.isEmpty()) {
            return null;
        }
        List<MediaTypeExpression> acceptedMediaTypes = this.getAcceptedMediaTypes(request);
        ArrayList<MediaTypeExpression> result = null;
        int size = this.expressions.size();
        block0: for (int i = 0; i < size; ++i) {
            MediaTypeExpression expression = this.expressions.get(i);
            int aSize = acceptedMediaTypes.size();
            for (int j = 0; j < aSize; ++j) {
                if (!expression.compatibleWith(acceptedMediaTypes.get(j))) continue;
                if (result == null) {
                    result = new ArrayList<MediaTypeExpression>();
                }
                result.add(expression);
                continue block0;
            }
        }
        return result == null ? null : new ProducesCondition(result);
    }

    private List<MediaTypeExpression> getAcceptedMediaTypes(HttpRequest request) {
        List<String> values = request.headerValues(HttpHeaderNames.ACCEPT.getKey());
        if (CollectionUtils.isEmpty(values)) {
            return MediaTypeExpression.ALL_LIST;
        }
        ArrayList<MediaTypeExpression> mediaTypes = null;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            String value = values.get(i);
            if (StringUtils.isEmpty(value)) continue;
            for (String item : StringUtils.tokenize(value, ',')) {
                MediaTypeExpression expression = MediaTypeExpression.parse(item);
                if (expression == null) continue;
                if (mediaTypes == null) {
                    mediaTypes = new ArrayList<MediaTypeExpression>();
                }
                mediaTypes.add(expression);
            }
        }
        if (mediaTypes == null) {
            return Collections.emptyList();
        }
        mediaTypes.sort(MediaTypeExpression.QUALITY_COMPARATOR.thenComparing(MediaTypeExpression.COMPARATOR));
        return mediaTypes;
    }

    @Override
    public int compareTo(ProducesCondition other, HttpRequest request) {
        if (this.expressions.isEmpty() && other.expressions.isEmpty()) {
            return 0;
        }
        List<MediaTypeExpression> mediaTypes = this.getAcceptedMediaTypes(request);
        int size = mediaTypes.size();
        for (int i = 0; i < size; ++i) {
            Pair<Integer, MediaTypeExpression> otherPair;
            MediaTypeExpression mediaType = mediaTypes.get(i);
            Pair<Integer, MediaTypeExpression> thisPair = this.findMediaType(mediaType, MediaTypeExpression::typesEquals);
            int result = this.compareMediaType(thisPair, otherPair = this.findMediaType(mediaType, MediaTypeExpression::typesEquals));
            if (result != 0) {
                return result;
            }
            thisPair = this.findMediaType(mediaType, MediaTypeExpression::compatibleWith);
            result = this.compareMediaType(thisPair, otherPair = this.findMediaType(mediaType, MediaTypeExpression::compatibleWith));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public List<MediaType> getMediaTypes() {
        List<MediaTypeExpression> expressions = this.expressions;
        int size = expressions.size();
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(size);
        for (int i = 0; i < size; ++i) {
            MediaTypeExpression expr = expressions.get(i);
            mediaTypes.add(new MediaType(expr.getType(), expr.getSubType()));
        }
        return mediaTypes;
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ProducesCondition.class) {
            return false;
        }
        return this.expressions.equals(((ProducesCondition)obj).expressions);
    }

    private Pair<Integer, MediaTypeExpression> findMediaType(MediaTypeExpression mediaType, BiPredicate<MediaTypeExpression, MediaTypeExpression> tester) {
        List<MediaTypeExpression> toCompare = this.expressions.isEmpty() ? MediaTypeExpression.ALL_LIST : this.expressions;
        for (int i = 0; i < toCompare.size(); ++i) {
            MediaTypeExpression currentMediaType = toCompare.get(i);
            if (!tester.test(mediaType, currentMediaType)) continue;
            return Pair.of(i, currentMediaType);
        }
        return Pair.of(-1, null);
    }

    private int compareMediaType(Pair<Integer, MediaTypeExpression> p1, Pair<Integer, MediaTypeExpression> p2) {
        int index2;
        int index1 = p1.getLeft();
        if (index1 != (index2 = p2.getLeft().intValue())) {
            return index2 - index1;
        }
        return index1 != -1 ? p1.getRight().compareTo(p2.getRight()) : 0;
    }

    public String toString() {
        return "ProducesCondition{mediaTypes=" + this.expressions + '}';
    }
}

