/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.util.Objects;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ConditionWrapper;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ConsumesCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.HeadersCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.MethodsCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ParamsCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ProducesCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ServiceGroupVersionCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ResponseMeta;

public final class RequestMapping
implements Condition<RequestMapping, HttpRequest> {
    private final String name;
    private final String sig;
    private final PathCondition pathCondition;
    private final MethodsCondition methodsCondition;
    private final ParamsCondition paramsCondition;
    private final HeadersCondition headersCondition;
    private final ConsumesCondition consumesCondition;
    private final ProducesCondition producesCondition;
    private final ConditionWrapper customCondition;
    private final CorsMeta cors;
    private final ResponseMeta response;
    private int hashCode;

    private RequestMapping(String name, String sig, PathCondition pathCondition, MethodsCondition methodsCondition, ParamsCondition paramsCondition, HeadersCondition headersCondition, ConsumesCondition consumesCondition, ProducesCondition producesCondition, ConditionWrapper customCondition, CorsMeta cors, ResponseMeta response) {
        this.name = name;
        this.sig = sig;
        this.pathCondition = pathCondition;
        this.methodsCondition = methodsCondition;
        this.paramsCondition = paramsCondition;
        this.headersCondition = headersCondition;
        this.consumesCondition = consumesCondition;
        this.producesCondition = producesCondition;
        this.customCondition = customCondition;
        this.cors = cors;
        this.response = response;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RequestMapping combine(RequestMapping other) {
        return new RequestMapping(this.combineName(this.name, other.name, other.sig), other.sig, this.combine(this.pathCondition, other.pathCondition), this.combine(this.methodsCondition, other.methodsCondition), this.combine(this.paramsCondition, other.paramsCondition), this.combine(this.headersCondition, other.headersCondition), this.combine(this.consumesCondition, other.consumesCondition), this.combine(this.producesCondition, other.producesCondition), this.combine(this.customCondition, other.customCondition), CorsMeta.combine(this.cors, other.cors), ResponseMeta.combine(this.response, other.response));
    }

    private String combineName(String name, String otherName, String otherSig) {
        if (name == null) {
            name = otherName;
        } else if (otherName != null) {
            name = name + '#' + otherName;
        }
        return otherSig == null ? name : name + '~' + otherSig;
    }

    private <T extends Condition<T, HttpRequest>> T combine(T source, T other) {
        return (T)(source == null ? other : (other == null ? source : (Condition)source.combine(other)));
    }

    public RequestMapping match(HttpRequest request, PathExpression path) {
        return this.doMatch(request, new PathCondition(path));
    }

    public boolean matchMethod(String method) {
        return this.methodsCondition == null || this.methodsCondition.getMethods().contains(method);
    }

    @Override
    public RequestMapping match(HttpRequest request) {
        return this.doMatch(request, null);
    }

    private RequestMapping doMatch(HttpRequest request, PathCondition pathCondition) {
        String rSig;
        MethodsCondition methods = null;
        if (this.methodsCondition != null && (methods = this.methodsCondition.match(request)) == null) {
            return null;
        }
        PathCondition paths = pathCondition;
        if (paths == null && this.pathCondition != null && (paths = this.pathCondition.match(request)) == null) {
            return null;
        }
        ParamsCondition params = null;
        if (this.paramsCondition != null && (params = this.paramsCondition.match(request)) == null) {
            return null;
        }
        HeadersCondition headers = null;
        if (this.headersCondition != null && (headers = this.headersCondition.match(request)) == null) {
            return null;
        }
        ConsumesCondition consumes = null;
        if (this.consumesCondition != null && (consumes = this.consumesCondition.match(request)) == null) {
            return null;
        }
        ProducesCondition produces = null;
        if (this.producesCondition != null && (produces = this.producesCondition.match(request)) == null) {
            return null;
        }
        ConditionWrapper custom = null;
        if (this.customCondition != null && (custom = this.customCondition.match(request)) == null) {
            return null;
        }
        if (StringUtils.isNotEmpty(this.sig) && (rSig = (String)request.attribute(RestConstants.SIG_ATTRIBUTE)) != null && !rSig.equals(this.sig)) {
            return null;
        }
        return new RequestMapping(this.name, this.sig, paths, methods, params, headers, consumes, produces, custom, this.cors, this.response);
    }

    public String getName() {
        return this.name;
    }

    public String getSig() {
        return this.sig;
    }

    public PathCondition getPathCondition() {
        return this.pathCondition;
    }

    public MethodsCondition getMethodsCondition() {
        return this.methodsCondition;
    }

    public ProducesCondition getProducesCondition() {
        return this.producesCondition;
    }

    public CorsMeta getCors() {
        return this.cors;
    }

    public ResponseMeta getResponse() {
        return this.response;
    }

    @Override
    public int compareTo(RequestMapping other, HttpRequest request) {
        int result;
        if (this.methodsCondition != null && HttpMethods.HEAD.name().equals(request.method()) && (result = this.methodsCondition.compareTo(other.methodsCondition, request)) != 0) {
            return result;
        }
        if (this.pathCondition != null && (result = this.pathCondition.compareTo(other.pathCondition, request)) != 0) {
            return result;
        }
        if (this.paramsCondition != null && (result = this.paramsCondition.compareTo(other.paramsCondition, request)) != 0) {
            return result;
        }
        if (this.headersCondition != null && (result = this.headersCondition.compareTo(other.headersCondition, request)) != 0) {
            return result;
        }
        if (this.consumesCondition != null && (result = this.consumesCondition.compareTo(other.consumesCondition, request)) != 0) {
            return result;
        }
        if (this.producesCondition != null && (result = this.producesCondition.compareTo(other.producesCondition, request)) != 0) {
            return result;
        }
        if (this.methodsCondition != null && (result = this.methodsCondition.compareTo(other.methodsCondition, request)) != 0) {
            return result;
        }
        if (this.customCondition != null && (result = this.customCondition.compareTo(other.customCondition, request)) != 0) {
            return result;
        }
        if (this.sig != null && other.sig != null) {
            int size = request.queryParameters().size();
            int size1 = this.sig.length();
            int size2 = other.sig.length();
            if (size1 == size) {
                if (size2 != size) {
                    return -1;
                }
            } else if (size2 == size) {
                return 1;
            }
        }
        return 0;
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            this.hashCode = hashCode = Objects.hash(this.pathCondition, this.methodsCondition, this.paramsCondition, this.headersCondition, this.consumesCondition, this.producesCondition, this.customCondition, this.sig);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != RequestMapping.class) {
            return false;
        }
        RequestMapping other = (RequestMapping)obj;
        return Objects.equals(this.pathCondition, other.pathCondition) && Objects.equals(this.methodsCondition, other.methodsCondition) && Objects.equals(this.paramsCondition, other.paramsCondition) && Objects.equals(this.headersCondition, other.headersCondition) && Objects.equals(this.consumesCondition, other.consumesCondition) && Objects.equals(this.producesCondition, other.producesCondition) && Objects.equals(this.customCondition, other.customCondition) && Objects.equals(this.sig, other.sig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RequestMapping{name='");
        sb.append(this.name).append('\'');
        if (this.pathCondition != null) {
            sb.append(", path=").append(this.pathCondition);
        }
        if (this.methodsCondition != null) {
            sb.append(", methods=").append(this.methodsCondition);
        }
        if (this.paramsCondition != null) {
            sb.append(", params=").append(this.paramsCondition);
        }
        if (this.headersCondition != null) {
            sb.append(", headers=").append(this.headersCondition);
        }
        if (this.consumesCondition != null) {
            sb.append(", consumes=").append(this.consumesCondition);
        }
        if (this.producesCondition != null) {
            sb.append(", produces=").append(this.producesCondition);
        }
        if (this.customCondition != null) {
            sb.append(", custom=").append(this.customCondition);
        }
        if (this.response != null) {
            sb.append(", response=").append(this.response);
        }
        if (this.cors != null) {
            sb.append(", cors=").append(this.cors);
        }
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private String name;
        private String sig;
        private String contextPath;
        private String[] paths;
        private String[] methods;
        private String[] params;
        private String[] headers;
        private String[] consumes;
        private String[] produces;
        private Condition<?, HttpRequest> customCondition;
        private CorsMeta cors;
        private Integer responseStatus;
        private String responseReason;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sig(String sig) {
            this.sig = sig;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder path(String ... paths) {
            this.paths = paths;
            return this;
        }

        public Builder method(String ... methods) {
            this.methods = methods;
            return this;
        }

        public Builder param(String ... params) {
            this.params = params;
            return this;
        }

        public Builder header(String ... headers) {
            this.headers = headers;
            return this;
        }

        public Builder consume(String ... consumes) {
            this.consumes = consumes;
            return this;
        }

        public Builder produce(String ... produces) {
            this.produces = produces;
            return this;
        }

        public Builder custom(Condition<?, HttpRequest> customCondition) {
            this.customCondition = customCondition;
            return this;
        }

        public Builder service(String ServiceGroup, String ServiceVersion) {
            if (ServiceGroup != null || ServiceVersion != null) {
                this.customCondition = new ServiceGroupVersionCondition(ServiceGroup, ServiceVersion);
            }
            return this;
        }

        public Builder cors(CorsMeta cors) {
            this.cors = cors;
            return this;
        }

        public Builder responseStatus(int status) {
            this.responseStatus = status;
            return this;
        }

        public Builder responseReason(String reason) {
            this.responseReason = reason;
            return this;
        }

        public RequestMapping build() {
            return new RequestMapping(this.name, this.sig, ArrayUtils.isEmpty(this.paths) ? null : new PathCondition(this.contextPath, this.paths), ArrayUtils.isEmpty(this.methods) ? null : new MethodsCondition(this.methods), ArrayUtils.isEmpty(this.params) ? null : new ParamsCondition(this.params), ArrayUtils.isEmpty(this.headers) ? null : new HeadersCondition(this.headers), ArrayUtils.isEmpty(this.consumes) ? null : new ConsumesCondition(this.consumes), ArrayUtils.isEmpty(this.produces) ? null : new ProducesCondition(this.produces), this.customCondition == null ? null : ConditionWrapper.wrap(this.customCondition), this.cors == null ? null : this.cors, this.responseStatus == null ? null : new ResponseMeta(this.responseStatus, this.responseReason));
        }
    }
}

