/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoderFactory;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.CodecUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class ContentNegotiator {
    private final FrameworkModel frameworkModel;
    private final CodecUtils codecUtils;
    private Map<String, MediaType> extensionMapping;
    private String parameterName;

    public ContentNegotiator(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.codecUtils = frameworkModel.getBeanFactory().getOrRegisterBean(CodecUtils.class);
    }

    public String negotiate(HttpRequest request) {
        String format;
        List<String> accepts;
        String mediaType;
        List produces = (List)request.attribute("org.springframework.web.servlet.HandlerMapping.producibleMediaTypes");
        if (produces != null) {
            int size = produces.size();
            for (int i = 0; i < size; ++i) {
                mediaType = this.getSuitableMediaType(((MediaType)produces.get(i)).getName());
                if (mediaType == null) continue;
                return mediaType;
            }
        }
        if ((accepts = HttpUtils.parseAccept(request.accept())) != null) {
            int size = accepts.size();
            for (int i = 0; i < size; ++i) {
                mediaType = this.getSuitableMediaType(accepts.get(i));
                if (mediaType == null) continue;
                return mediaType;
            }
        }
        if ((format = request.queryParameter(this.getParameterName())) != null && (mediaType = this.getMediaTypeByExtension(format)) != null) {
            return mediaType;
        }
        String path = request.rawPath();
        int index = path.lastIndexOf(46);
        if (index != -1) {
            String extension = path.substring(index + 1);
            return this.getMediaTypeByExtension(extension);
        }
        return null;
    }

    public boolean supportExtension(String extension) {
        return this.getMediaTypeByExtension(extension) != null;
    }

    private String getSuitableMediaType(String name) {
        int index = name.indexOf(47);
        if (index == -1 || index == name.length() - 1) {
            return null;
        }
        String type = name.substring(0, index);
        if ("*".equals(type)) {
            return null;
        }
        String subType = name.substring(index + 1);
        if ("*".equals(subType)) {
            return MediaType.TEXT_PLAIN.getType().equals(type) ? MediaType.TEXT_PLAIN.getName() : null;
        }
        int suffixIndex = subType.lastIndexOf(43);
        if (suffixIndex != -1) {
            return this.getMediaTypeByExtension(subType.substring(suffixIndex + 1));
        }
        return name;
    }

    public String getParameterName() {
        String parameterName = this.parameterName;
        if (parameterName == null) {
            Configuration conf = ConfigurationUtils.getGlobalConfiguration(this.frameworkModel.defaultApplication());
            this.parameterName = parameterName = conf.getString("dubbo.protocol.triple.rest.format-parameter-name", "format");
        }
        return parameterName;
    }

    private String getMediaTypeByExtension(String extension) {
        MediaType mediaType;
        Map<String, MediaType> extensionMapping = this.extensionMapping;
        if (extensionMapping == null) {
            extensionMapping = new HashMap<String, MediaType>();
            for (HttpMessageEncoderFactory factory : this.codecUtils.getEncoderFactories()) {
                MediaType mediaType2 = factory.mediaType();
                String subType = mediaType2.getSubType();
                int index = subType.lastIndexOf(43);
                if (index != -1) {
                    subType = subType.substring(index + 1);
                }
                extensionMapping.putIfAbsent(subType, mediaType2);
            }
            extensionMapping.put("css", MediaType.TEXT_CSS);
            extensionMapping.put("js", MediaType.TEXT_JAVASCRIPT);
            extensionMapping.put("yml", MediaType.APPLICATION_YAML);
            extensionMapping.put("xhtml", MediaType.TEXT_HTML);
            extensionMapping.put("html", MediaType.TEXT_HTML);
            extensionMapping.put("htm", MediaType.TEXT_HTML);
            for (String ext : new String[]{"txt", "md", "csv", "log", "properties"}) {
                extensionMapping.put(ext, MediaType.TEXT_PLAIN);
            }
            this.extensionMapping = extensionMapping;
        }
        return (mediaType = extensionMapping.get(extension)) == null ? null : mediaType.getName();
    }
}

