/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.argument;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.DateUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpJsonUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.CodecUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.RestParameterException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public class GeneralTypeConverter
implements TypeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralTypeConverter.class);
    private final CompositeArgumentConverter converter;
    private final CodecUtils codecUtils;
    private final HttpJsonUtils httpJsonUtils;

    public GeneralTypeConverter(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.converter = beanFactory.getOrRegisterBean(CompositeArgumentConverter.class);
        this.codecUtils = beanFactory.getOrRegisterBean(CodecUtils.class);
        this.httpJsonUtils = beanFactory.getOrRegisterBean(HttpJsonUtils.class);
    }

    @Override
    public <T> T convert(Object source, Class<T> targetClass) {
        try {
            return (T)(targetClass == null ? source : this.doConvert(source, targetClass));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    @Override
    public <T> T convert(Object source, Type targetType) {
        try {
            return (T)(targetType == null ? source : this.doConvert(source, targetType));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    private <T> Object doConvert(Object source, Class<T> targetClass) throws Exception {
        Object arr;
        InputStream is;
        Object list;
        Object target;
        if (source == null) {
            return TypeUtils.nullDefault(targetClass);
        }
        if (targetClass.isInstance(source)) {
            return source;
        }
        if (targetClass == Optional.class) {
            return Optional.of(source);
        }
        Class<?> sourceClass = source.getClass();
        if (sourceClass == Optional.class) {
            if ((source = ((Optional)source).orElse(null)) == null) {
                return TypeUtils.nullDefault(targetClass);
            }
            if (targetClass.isInstance(source)) {
                return source;
            }
        }
        if ((target = this.customConvert(source, targetClass)) != null) {
            return target;
        }
        if (source instanceof CharSequence) {
            String str = source.toString();
            if (targetClass == String.class) {
                return str;
            }
            if (str.isEmpty() || "null".equals(str) || "NULL".equals(str)) {
                return this.emptyDefault(targetClass);
            }
            switch (targetClass.getName()) {
                case "java.lang.Double": 
                case "double": {
                    return Double.valueOf(str);
                }
                case "java.lang.Float": 
                case "float": {
                    return Float.valueOf(str);
                }
                case "java.lang.Long": 
                case "long": {
                    return GeneralTypeConverter.isHexNumber(str) ? Long.decode(str) : Long.valueOf(str);
                }
                case "java.lang.Integer": 
                case "int": {
                    return GeneralTypeConverter.isHexNumber(str) ? Integer.decode(str) : Integer.valueOf(str);
                }
                case "java.lang.Short": 
                case "short": {
                    return GeneralTypeConverter.isHexNumber(str) ? Short.decode(str) : Short.valueOf(str);
                }
                case "java.lang.Character": 
                case "char": {
                    if (str.length() == 1) {
                        return Character.valueOf(str.charAt(0));
                    }
                    throw new RestParameterException("Can not convert String(" + str + ") to char, must only 1 char");
                }
                case "java.lang.Byte": 
                case "byte": {
                    return GeneralTypeConverter.isHexNumber(str) ? Byte.decode(str) : Byte.valueOf(str);
                }
                case "java.lang.Boolean": {
                    return GeneralTypeConverter.toBoolean(str);
                }
                case "boolean": {
                    return GeneralTypeConverter.toBoolean(str) == Boolean.TRUE;
                }
                case "java.math.BigInteger": {
                    return new BigInteger(str);
                }
                case "java.math.BigDecimal": {
                    return new BigDecimal(str);
                }
                case "java.lang.Number": {
                    return str.indexOf(46) == -1 ? this.doConvert((Object)str, Long.class) : this.doConvert((Object)str, Double.class);
                }
                case "java.util.Date": {
                    return DateUtils.parse(str);
                }
                case "java.util.Calendar": {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(DateUtils.parse(str).getTime());
                    return cal;
                }
                case "java.sql.Timestamp": {
                    return new Timestamp(DateUtils.parse(str).getTime());
                }
                case "java.time.Instant": {
                    return DateUtils.parse(str).toInstant();
                }
                case "java.time.ZonedDateTime": {
                    return GeneralTypeConverter.toZonedDateTime(str);
                }
                case "java.time.LocalDate": {
                    return GeneralTypeConverter.toZonedDateTime(str).toLocalDate();
                }
                case "java.time.LocalTime": {
                    return GeneralTypeConverter.toZonedDateTime(str).toLocalTime();
                }
                case "java.time.LocalDateTime": {
                    return GeneralTypeConverter.toZonedDateTime(str).toLocalDateTime();
                }
                case "java.time.ZoneId": {
                    return TimeZone.getTimeZone(str).toZoneId();
                }
                case "java.util.TimeZone": {
                    return TimeZone.getTimeZone(str);
                }
                case "java.io.File": {
                    return new File(str);
                }
                case "java.nio.file.Path": {
                    return Paths.get(str, new String[0]);
                }
                case "java.nio.charset.Charset": {
                    return Charset.forName(str);
                }
                case "java.net.InetAddress": {
                    return InetAddress.getByName(str);
                }
                case "java.net.URI": {
                    return new URI(str);
                }
                case "java.net.URL": {
                    return new URL(str);
                }
                case "java.util.UUID": {
                    return UUID.fromString(str);
                }
                case "java.util.Locale": {
                    String[] parts = StringUtils.tokenize(str, '-', '_');
                    switch (parts.length) {
                        case 2: {
                            return new Locale(parts[0], parts[1]);
                        }
                        case 3: {
                            return new Locale(parts[0], parts[1], parts[2]);
                        }
                    }
                    return new Locale(parts[0]);
                }
                case "java.util.Currency": {
                    return Currency.getInstance(str);
                }
                case "java.util.regex.Pattern": {
                    return Pattern.compile(str);
                }
                case "java.lang.Class": {
                    return ClassUtils.loadClass(str);
                }
                case "[B": {
                    return str.getBytes(StandardCharsets.UTF_8);
                }
                case "[C": {
                    return str.toCharArray();
                }
                case "java.util.OptionalInt": {
                    return OptionalInt.of(GeneralTypeConverter.isHexNumber(str) ? Integer.decode(str) : Integer.parseInt(str));
                }
                case "java.util.OptionalLong": {
                    return OptionalLong.of(GeneralTypeConverter.isHexNumber(str) ? Long.decode(str) : Long.parseLong(str));
                }
                case "java.util.OptionalDouble": {
                    return OptionalDouble.of(Double.parseDouble(str));
                }
                case "java.util.Properties": {
                    Properties properties = new Properties();
                    properties.load(new StringReader(str));
                    return properties;
                }
            }
            if (targetClass.isEnum()) {
                try {
                    return Enum.valueOf(targetClass, str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((target = this.jsonToObject(str, targetClass)) != null) {
                return target;
            }
            if (targetClass.isArray()) {
                list = StringUtils.tokenizeToList(str, new char[0]);
                int n = list.size();
                Class<?> itemType = targetClass.getComponentType();
                if (itemType == String.class) {
                    return list.toArray(StringUtils.EMPTY_STRING_ARRAY);
                }
                Object arr2 = Array.newInstance(itemType, n);
                for (int i = 0; i < n; ++i) {
                    Array.set(arr2, i, this.doConvert(list.get(i), itemType));
                }
                return arr2;
            }
            if (Collection.class.isAssignableFrom(targetClass) ? (target = this.convertCollection(StringUtils.tokenizeToList(str, new char[0]), targetClass)) != null : Map.class.isAssignableFrom(targetClass) && (target = this.convertMap(GeneralTypeConverter.tokenizeToMap(str), targetClass)) != null) {
                return target;
            }
        } else if (source instanceof Number) {
            Number num = (Number)source;
            switch (targetClass.getName()) {
                case "java.lang.String": {
                    return source.toString();
                }
                case "java.lang.Double": 
                case "double": {
                    return num.doubleValue();
                }
                case "java.lang.Float": 
                case "float": {
                    return Float.valueOf(num.floatValue());
                }
                case "java.lang.Long": 
                case "long": {
                    return num.longValue();
                }
                case "java.lang.Integer": 
                case "int": {
                    return num.intValue();
                }
                case "java.lang.Short": 
                case "short": {
                    return num.shortValue();
                }
                case "java.lang.Character": 
                case "char": {
                    return Character.valueOf((char)num.intValue());
                }
                case "java.lang.Byte": 
                case "byte": {
                    return num.byteValue();
                }
                case "java.lang.Boolean": 
                case "boolean": {
                    return GeneralTypeConverter.toBoolean(num);
                }
                case "java.math.BigInteger": {
                    return BigInteger.valueOf(num.longValue());
                }
                case "java.math.BigDecimal": {
                    return BigDecimal.valueOf(num.doubleValue());
                }
                case "java.util.Date": {
                    return new Date(num.longValue());
                }
                case "java.util.Calendar": {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(num.longValue());
                    return cal;
                }
                case "java.sql.Timestamp": {
                    return new Timestamp(num.longValue());
                }
                case "java.time.Instant": {
                    return Instant.ofEpochMilli(num.longValue());
                }
                case "java.time.ZonedDateTime": {
                    return GeneralTypeConverter.toZonedDateTime(num);
                }
                case "java.time.LocalDate": {
                    return GeneralTypeConverter.toZonedDateTime(num).toLocalDate();
                }
                case "java.time.LocalTime": {
                    return GeneralTypeConverter.toZonedDateTime(num).toLocalTime();
                }
                case "java.time.LocalDateTime": {
                    return GeneralTypeConverter.toZonedDateTime(num).toLocalDateTime();
                }
                case "java.util.TimeZone": {
                    return GeneralTypeConverter.toTimeZone(num.intValue());
                }
                case "[B": {
                    return GeneralTypeConverter.toBytes(num);
                }
                case "[C": {
                    return new char[]{(char)num.intValue()};
                }
                case "java.util.OptionalInt": {
                    return OptionalInt.of(num.intValue());
                }
                case "java.util.OptionalLong": {
                    return OptionalLong.of(num.longValue());
                }
                case "java.util.OptionalDouble": {
                    return OptionalDouble.of(num.doubleValue());
                }
            }
            if (targetClass.isEnum()) {
                for (Iterator e : targetClass.getEnumConstants()) {
                    if (((Enum)((Object)e)).ordinal() != num.intValue()) continue;
                    return e;
                }
            }
        } else if (source instanceof Date) {
            Date date = (Date)source;
            switch (targetClass.getName()) {
                case "java.lang.String": {
                    return DateUtils.format(date);
                }
                case "java.lang.Long": 
                case "long": {
                    return date.getTime();
                }
                case "java.lang.Integer": 
                case "int": {
                    return (int)(date.getTime() / 1000L);
                }
                case "java.util.Calendar": {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(date.getTime());
                    return cal;
                }
                case "java.time.Instant": {
                    return date.toInstant();
                }
                case "java.time.ZonedDateTime": {
                    return GeneralTypeConverter.toZonedDateTime(date.getTime());
                }
                case "java.time.LocalDate": {
                    return GeneralTypeConverter.toZonedDateTime(date.getTime()).toLocalDate();
                }
                case "java.time.LocalTime": {
                    return GeneralTypeConverter.toZonedDateTime(date.getTime()).toLocalTime();
                }
                case "java.time.LocalDateTime": {
                    return GeneralTypeConverter.toZonedDateTime(date.getTime()).toLocalDateTime();
                }
            }
        } else {
            if (source instanceof TemporalAccessor) {
                return this.doConvert((Object)DateUtils.toDate((TemporalAccessor)source), targetClass);
            }
            if (source instanceof Enum) {
                Enum en = (Enum)source;
                if (targetClass == String.class) {
                    return en.toString();
                }
                if (targetClass == Integer.TYPE || targetClass == Integer.class) {
                    return en.ordinal();
                }
                if (Number.class.isAssignableFrom(targetClass)) {
                    return this.doConvert((Object)en.ordinal(), targetClass);
                }
                if (targetClass.isEnum()) {
                    return Enum.valueOf(targetClass, en.name());
                }
            } else if (source instanceof byte[]) {
                byte[] bytes = (byte[])source;
                if (bytes.length == 0) {
                    return this.emptyDefault(targetClass);
                }
                switch (targetClass.getName()) {
                    case "java.lang.String": {
                        return new String(bytes, StandardCharsets.UTF_8);
                    }
                    case "java.lang.Double": 
                    case "double": {
                        return ByteBuffer.wrap(bytes).getDouble();
                    }
                    case "java.lang.Float": 
                    case "float": {
                        return Float.valueOf(ByteBuffer.wrap(bytes).getFloat());
                    }
                    case "java.lang.Long": 
                    case "long": {
                        return ByteBuffer.wrap(bytes).getLong();
                    }
                    case "java.lang.Integer": 
                    case "int": {
                        return ByteBuffer.wrap(bytes).getInt();
                    }
                    case "java.lang.Short": 
                    case "short": {
                        return ByteBuffer.wrap(bytes).getShort();
                    }
                    case "java.lang.Character": 
                    case "char": {
                        return Character.valueOf(ByteBuffer.wrap(bytes).getChar());
                    }
                    case "java.lang.Byte": 
                    case "byte": {
                        return bytes[0];
                    }
                    case "java.lang.Boolean": 
                    case "boolean": {
                        return bytes[0] == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case "java.math.BigInteger": {
                        return new BigInteger(bytes);
                    }
                    case "java.util.Properties": {
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(bytes));
                        return properties;
                    }
                }
                target = this.jsonToObject(new String(bytes, StandardCharsets.ISO_8859_1), targetClass);
                if (target != null) {
                    return target;
                }
            }
        }
        if (targetClass.isArray()) {
            if (targetClass == byte[].class) {
                if (source instanceof InputStream) {
                    is = (InputStream)source;
                    try {
                        list = StreamUtils.readBytes(is);
                        return list;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                if (source instanceof HttpRequest.FileUpload) {
                    is = ((HttpRequest.FileUpload)source).inputStream();
                    try {
                        list = StreamUtils.readBytes(is);
                        return list;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                if (source instanceof Character) {
                    char c = ((Character)source).charValue();
                    return new byte[]{(byte)(c >> 8), (byte)c};
                }
                if (source instanceof Boolean) {
                    boolean b = (Boolean)source;
                    return new byte[]{b ? (byte)1 : 0};
                }
            }
            Class<?> itemType = targetClass.getComponentType();
            if (source instanceof Collection) {
                Collection c = (Collection)source;
                int i = 0;
                Object arr3 = Array.newInstance(itemType, c.size());
                for (Object item : c) {
                    Array.set(arr3, i++, item == null ? null : this.doConvert(item, itemType));
                }
                return arr3;
            }
            if (source instanceof Iterable) {
                list = new ArrayList();
                for (Object item : (Iterable)source) {
                    list.add(item == null ? null : this.doConvert(item, itemType));
                }
                return list.toArray((Object[])Array.newInstance(itemType, 0));
            }
            if (sourceClass.isArray()) {
                int len = Array.getLength(source);
                Object arr4 = Array.newInstance(itemType, len);
                for (int i = 0; i < len; ++i) {
                    Object item = Array.get(source, i);
                    Array.set(arr4, i, item == null ? null : this.doConvert(item, itemType));
                }
                return arr4;
            }
            arr = Array.newInstance(itemType, 1);
            Array.set(arr, 0, this.doConvert(source, itemType));
            return arr;
        }
        if (Collection.class.isAssignableFrom(targetClass) && (target = this.convertCollection(GeneralTypeConverter.toCollection(source), targetClass)) != null) {
            return target;
        }
        if (Map.class.isAssignableFrom(targetClass) && source instanceof Map && (target = this.convertMap((Map)source, targetClass)) != null) {
            return target;
        }
        if (sourceClass.isArray()) {
            if (Array.getLength(source) == 0) {
                return TypeUtils.nullDefault(targetClass);
            }
            return this.doConvert(Array.get(source, 0), targetClass);
        }
        if (source instanceof List) {
            List list2 = (List)source;
            if (list2.isEmpty()) {
                return TypeUtils.nullDefault(targetClass);
            }
            return this.doConvert(list2.get(0), targetClass);
        }
        if (source instanceof Iterable) {
            Iterator it = ((Iterable)source).iterator();
            if (!it.hasNext()) {
                return TypeUtils.nullDefault(targetClass);
            }
            return this.doConvert(it.next(), targetClass);
        }
        if (targetClass == String.class) {
            if (sourceClass == HttpCookie.class) {
                return ((HttpCookie)source).value();
            }
            if (source instanceof InputStream) {
                is = (InputStream)source;
                try {
                    arr = StreamUtils.toString(is);
                    return arr;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            if (source instanceof HttpRequest.FileUpload) {
                HttpRequest.FileUpload fu = (HttpRequest.FileUpload)source;
                try (InputStream is2 = fu.inputStream();){
                    int index22;
                    String contentType = fu.contentType();
                    if (contentType != null && (index22 = contentType.lastIndexOf("charset=")) > 0) {
                        String string = StreamUtils.toString(is2, Charset.forName(contentType.substring(index22 + 8).trim()));
                        return string;
                    }
                    String index22 = StreamUtils.toString(is2);
                    return index22;
                }
            }
            return source.toString();
        }
        if (!Modifier.isAbstract(targetClass.getModifiers())) {
            try {
                for (Constructor<?> ct : targetClass.getConstructors()) {
                    if (ct.getParameterCount() != 1 || !ct.getParameterTypes()[0].isAssignableFrom(sourceClass)) continue;
                    return ct.newInstance(source);
                }
            }
            catch (Throwable fu) {
                // empty catch block
            }
        }
        if (sourceClass == String.class) {
            try {
                Method valueOf = targetClass.getMethod("valueOf", String.class);
                return valueOf.invoke(null, source);
            }
            catch (Throwable valueOf) {
                return null;
            }
        }
        try {
            return this.httpJsonUtils.convertObject(source, targetClass);
        }
        catch (Throwable t) {
            String msg = "JSON convert value '{}' from type [{}] to type [{}] failed";
            LOGGER.debug(msg, source, sourceClass, targetClass, t);
            return null;
        }
    }

    private Object doConvert(Object source, Type targetType) throws Exception {
        if (targetType instanceof Class) {
            return this.doConvert((Object)source, (Class)targetType);
        }
        if (source == null) {
            return TypeUtils.nullDefault(TypeUtils.getActualType(targetType));
        }
        if (source.getClass() == Optional.class && (source = ((Optional)((Object)source)).orElse(null)) == null) {
            return TypeUtils.nullDefault(TypeUtils.getActualType(targetType));
        }
        if (source instanceof CharSequence) {
            String str = source.toString();
            if (str.isEmpty() || "null".equals(str) || "NULL".equals(str)) {
                return this.emptyDefault(TypeUtils.getActualType(targetType));
            }
            Object target = this.jsonToObject(str, targetType);
            if (target != null) {
                return target;
            }
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)targetType;
            Type rawType = type.getRawType();
            if (rawType instanceof Class) {
                Class targetClass = (Class)rawType;
                Type[] argTypes = type.getActualTypeArguments();
                if (Collection.class.isAssignableFrom(targetClass)) {
                    Type itemType = TypeUtils.getActualGenericType(argTypes[0]);
                    if (itemType instanceof Class && targetClass.isInstance(source)) {
                        boolean same = true;
                        Class itemClass = (Class)itemType;
                        for (Object item : (Collection)((Object)source)) {
                            if (item == null || itemClass.isInstance(item)) continue;
                            same = false;
                            break;
                        }
                        if (same) {
                            return source;
                        }
                    }
                    Collection items = GeneralTypeConverter.toCollection(source);
                    Collection targetItems = this.createCollection(targetClass, items.size());
                    for (Object item : items) {
                        targetItems.add(this.doConvert(item, itemType));
                    }
                    return targetItems;
                }
                if (Map.class.isAssignableFrom(targetClass)) {
                    Class<?> mapValueClass;
                    boolean multiValue;
                    Type keyType = argTypes[0];
                    Type valueType = argTypes[1];
                    if (keyType instanceof Class && valueType instanceof Class && targetClass.isInstance(source)) {
                        boolean same = true;
                        Class keyClass = (Class)keyType;
                        Class valueClass = (Class)valueType;
                        for (Map.Entry<String, String> entry : source.entrySet()) {
                            String key = entry.getKey();
                            if (key != null && !keyClass.isInstance(key)) {
                                same = false;
                                break;
                            }
                            String value = entry.getValue();
                            if (value == null || valueClass.isInstance(value)) continue;
                            same = false;
                            break;
                        }
                        if (same) {
                            return source;
                        }
                    }
                    boolean bl = multiValue = (mapValueClass = TypeUtils.getMapValueType(targetClass)) != null && Collection.class.isAssignableFrom(mapValueClass);
                    if (source instanceof CharSequence) {
                        source = GeneralTypeConverter.tokenizeToMap(source.toString());
                    }
                    if (source instanceof Map) {
                        Map<String, String> map = source;
                        Map targetMap = this.createMap(targetClass, map.size());
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            Object key = this.doConvert((Object)entry.getKey(), keyType);
                            if (multiValue) {
                                Collection items = GeneralTypeConverter.toCollection(entry.getValue());
                                Collection targetItems = this.createCollection(mapValueClass, items.size());
                                for (Object item : items) {
                                    targetItems.add(this.doConvert(item, valueType));
                                }
                                targetMap.put(key, targetItems);
                                continue;
                            }
                            targetMap.put(key, this.doConvert((Object)entry.getValue(), valueType));
                        }
                        return targetMap;
                    }
                }
                if (targetClass == Optional.class) {
                    return Optional.ofNullable(this.doConvert((Object)source, argTypes[0]));
                }
            }
        } else {
            if (targetType instanceof TypeVariable) {
                return this.doConvert((Object)source, ((TypeVariable)targetType).getBounds()[0]);
            }
            if (targetType instanceof WildcardType) {
                return this.doConvert((Object)source, ((WildcardType)targetType).getUpperBounds()[0]);
            }
            if (targetType instanceof GenericArrayType) {
                Type itemType = ((GenericArrayType)targetType).getGenericComponentType();
                Class<?> itemClass = TypeUtils.getActualType(itemType);
                Collection items = GeneralTypeConverter.toCollection(source);
                Object target = Array.newInstance(itemClass, items.size());
                int i = 0;
                for (Object item : items) {
                    Array.set(target, i++, this.doConvert(item, itemType));
                }
                return target;
            }
        }
        try {
            return this.httpJsonUtils.convertObject((Object)source, targetType);
        }
        catch (Throwable t) {
            String msg = "JSON convert value '{}' from type [{}] to type [{}] failed";
            LOGGER.debug(msg, source, source.getClass(), targetType, t);
            return null;
        }
    }

    protected Object customConvert(Object source, Class<?> targetClass) {
        return this.converter.convert(source, targetClass);
    }

    protected Collection customCreateCollection(Class targetClass, int size) {
        return (Collection)this.converter.convert((Object)size, targetClass);
    }

    protected Map customCreateMap(Class targetClass, int size) {
        return (Map)this.converter.convert((Object)size, targetClass);
    }

    private Collection createCollection(Class targetClass, int size) {
        Collection collection;
        if (targetClass.isInterface()) {
            if (targetClass == List.class || targetClass == Collection.class) {
                return new ArrayList(size);
            }
            if (targetClass == Set.class) {
                return CollectionUtils.newHashSet(size);
            }
            if (targetClass == SortedSet.class) {
                return CollectionUtils.newLinkedHashSet(size);
            }
            if (targetClass == Queue.class || targetClass == Deque.class) {
                return new LinkedList();
            }
        } else if (Collection.class.isAssignableFrom(targetClass)) {
            if (targetClass == ArrayList.class) {
                return new ArrayList(size);
            }
            if (targetClass == LinkedList.class) {
                return new LinkedList();
            }
            if (targetClass == HashSet.class) {
                return CollectionUtils.newHashSet(size);
            }
            if (targetClass == LinkedHashSet.class) {
                return CollectionUtils.newLinkedHashSet(size);
            }
            if (!Modifier.isAbstract(targetClass.getModifiers())) {
                try {
                    Constructor<?> defCt = null;
                    block6: for (Constructor<?> ct : targetClass.getConstructors()) {
                        switch (ct.getParameterCount()) {
                            case 0: {
                                defCt = ct;
                                continue block6;
                            }
                            case 1: {
                                Class<?> paramType = ct.getParameterTypes()[0];
                                if (paramType != Integer.TYPE) continue block6;
                                return (Collection)ct.newInstance(size);
                            }
                        }
                    }
                    if (defCt != null) {
                        return (Collection)defCt.newInstance(new Object[0]);
                    }
                }
                catch (Exception defCt) {
                    // empty catch block
                }
            }
        }
        if ((collection = this.customCreateCollection(targetClass, size)) != null) {
            return collection;
        }
        if (targetClass.isAssignableFrom(ArrayList.class)) {
            return new ArrayList(size);
        }
        if (targetClass.isAssignableFrom(LinkedHashSet.class)) {
            return CollectionUtils.newLinkedHashSet(size);
        }
        throw new IllegalArgumentException("Unsupported collection type: " + targetClass.getName());
    }

    private Collection convertCollection(Collection source, Class targetClass) {
        if (targetClass.isInstance(source)) {
            return source;
        }
        if (targetClass.isInterface()) {
            if (targetClass == List.class || targetClass == Collection.class) {
                return new ArrayList(source);
            }
            if (targetClass == Set.class) {
                return new HashSet(source);
            }
            if (targetClass == SortedSet.class) {
                return new LinkedHashSet(source);
            }
            if (targetClass == Queue.class || targetClass == Deque.class) {
                return new LinkedList(source);
            }
        } else {
            if (targetClass == ArrayList.class) {
                return new ArrayList(source);
            }
            if (targetClass == LinkedList.class) {
                return new LinkedList(source);
            }
            if (targetClass == HashSet.class) {
                return new HashSet(source);
            }
            if (targetClass == LinkedHashSet.class) {
                return new LinkedHashSet(source);
            }
            if (Modifier.isAbstract(targetClass.getModifiers())) {
                Collection collection = this.customCreateCollection(targetClass, source.size());
                if (collection != null) {
                    collection.addAll(source);
                    return collection;
                }
                if (targetClass.isAssignableFrom(ArrayList.class)) {
                    return new ArrayList(source);
                }
                if (targetClass.isAssignableFrom(LinkedHashSet.class)) {
                    return new LinkedHashSet(source);
                }
                return null;
            }
            try {
                Constructor<?> defCt = null;
                block6: for (Constructor<?> ct : targetClass.getConstructors()) {
                    if (!Modifier.isPublic(ct.getModifiers())) continue;
                    switch (ct.getParameterCount()) {
                        case 0: {
                            defCt = ct;
                            continue block6;
                        }
                        case 1: {
                            Class<?> paramType = ct.getParameterTypes()[0];
                            if (paramType == Collection.class) {
                                return (Collection)ct.newInstance(source);
                            }
                            if (paramType != List.class) continue block6;
                            return (Collection)ct.newInstance(GeneralTypeConverter.toList(source));
                        }
                    }
                }
                if (defCt != null) {
                    Collection c = (Collection)defCt.newInstance(new Object[0]);
                    c.addAll(source);
                    return c;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Map createMap(Class targetClass, int size) {
        Map map;
        if (targetClass.isInterface()) {
            if (targetClass == Map.class) {
                return CollectionUtils.newHashMap(size);
            }
            if (targetClass == ConcurrentMap.class) {
                return CollectionUtils.newConcurrentHashMap(size);
            }
            if (SortedMap.class.isAssignableFrom(targetClass)) {
                return new TreeMap();
            }
        } else if (Map.class.isAssignableFrom(targetClass)) {
            if (targetClass == HashMap.class) {
                return CollectionUtils.newHashMap(size);
            }
            if (targetClass == LinkedHashMap.class) {
                return CollectionUtils.newLinkedHashMap(size);
            }
            if (targetClass == TreeMap.class) {
                return new TreeMap();
            }
            if (targetClass == ConcurrentHashMap.class) {
                return CollectionUtils.newConcurrentHashMap(size);
            }
            if (!Modifier.isAbstract(targetClass.getModifiers())) {
                try {
                    Constructor<?> defCt = null;
                    block6: for (Constructor<?> ct : targetClass.getConstructors()) {
                        if (!Modifier.isPublic(ct.getModifiers())) continue;
                        switch (ct.getParameterCount()) {
                            case 0: {
                                defCt = ct;
                                continue block6;
                            }
                            case 1: {
                                if (ct.getParameterTypes()[0] != Integer.TYPE) continue block6;
                                return (Map)ct.newInstance(CollectionUtils.capacity(size));
                            }
                        }
                    }
                    if (defCt != null) {
                        return (Map)defCt.newInstance(new Object[0]);
                    }
                }
                catch (Throwable defCt) {
                    // empty catch block
                }
            }
        }
        if ((map = this.customCreateMap(targetClass, size)) != null) {
            return map;
        }
        if (targetClass.isAssignableFrom(LinkedHashMap.class)) {
            return CollectionUtils.newLinkedHashMap(size);
        }
        throw new IllegalArgumentException("Unsupported map type: " + targetClass.getName());
    }

    private Map convertMap(Map source, Class targetClass) {
        if (targetClass.isInstance(source)) {
            return source;
        }
        if (targetClass.isInterface()) {
            if (targetClass == Map.class) {
                return new HashMap(source);
            }
            if (targetClass == ConcurrentMap.class) {
                return new ConcurrentHashMap(source);
            }
            if (SortedMap.class.isAssignableFrom(targetClass)) {
                return new TreeMap(source);
            }
        } else {
            if (targetClass == HashMap.class) {
                return new HashMap(source);
            }
            if (targetClass == LinkedHashMap.class) {
                return new LinkedHashMap(source);
            }
            if (targetClass == TreeMap.class) {
                return new TreeMap(source);
            }
            if (targetClass == ConcurrentHashMap.class) {
                return new ConcurrentHashMap(source);
            }
            if (Modifier.isAbstract(targetClass.getModifiers())) {
                Map map = this.customCreateMap(targetClass, source.size());
                if (map != null) {
                    map.putAll(source);
                    return map;
                }
                if (targetClass.isAssignableFrom(LinkedHashMap.class)) {
                    return new LinkedHashMap(source);
                }
                return null;
            }
            try {
                Constructor<?> defCt = null;
                block6: for (Constructor<?> ct : targetClass.getConstructors()) {
                    switch (ct.getParameterCount()) {
                        case 0: {
                            defCt = ct;
                            continue block6;
                        }
                        case 1: {
                            Class<?> paramType = ct.getParameterTypes()[0];
                            if (paramType != Map.class) continue block6;
                            return (Map)ct.newInstance(source);
                        }
                    }
                }
                if (defCt != null) {
                    Map map = (Map)defCt.newInstance(new Object[0]);
                    map.putAll(source);
                    return map;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object emptyDefault(Class targetClass) {
        if (targetClass == null) {
            return null;
        }
        if (targetClass.isPrimitive()) {
            return TypeUtils.nullDefault(targetClass);
        }
        if (targetClass == Optional.class) {
            return Optional.empty();
        }
        if (List.class.isAssignableFrom(targetClass)) {
            return targetClass == List.class ? Collections.EMPTY_LIST : this.createCollection(targetClass, 0);
        }
        if (Set.class.isAssignableFrom(targetClass)) {
            return targetClass == Set.class ? Collections.EMPTY_SET : this.createCollection(targetClass, 0);
        }
        if (Map.class.isAssignableFrom(targetClass)) {
            return targetClass == Map.class ? Collections.EMPTY_MAP : this.createMap(targetClass, 0);
        }
        if (targetClass.isArray()) {
            return Array.newInstance(targetClass.getComponentType(), 0);
        }
        return null;
    }

    private static Map<String, String> tokenizeToMap(String str) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String item : StringUtils.tokenizeToList(str, ';')) {
            int index = item.indexOf(61);
            if (index == -1) {
                result.put(item, null);
                continue;
            }
            result.put(item.substring(0, index).trim(), RequestUtils.decodeURL(item.substring(index + 1).trim()));
        }
        return result;
    }

    private static boolean isMaybeJSONObjectOrArray(String str) {
        int i;
        if (str == null) {
            return false;
        }
        int n = str.length();
        if (n < 3) {
            return false;
        }
        char expected = '\u0000';
        for (i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == '{') {
                expected = '}';
                break;
            }
            if (c == '[') {
                expected = ']';
                break;
            }
            return false;
        }
        for (int j = n - 1; j > i; --j) {
            char c = str.charAt(j);
            if (Character.isWhitespace(c)) continue;
            return c == expected;
        }
        return false;
    }

    private Object jsonToObject(String value, Type targetType) {
        if (GeneralTypeConverter.isMaybeJSONObjectOrArray(value)) {
            try {
                return targetType instanceof Class ? this.codecUtils.determineHttpMessageDecoder(MediaType.APPLICATION_JSON.getName()).decode((InputStream)new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)), (Class)targetType) : this.httpJsonUtils.toJavaObject(value, targetType);
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to parse value '{}' from json string '{}'", targetType, value, t);
            }
        }
        return null;
    }

    private static boolean isHexNumber(String value) {
        if (value.length() < 3) {
            return false;
        }
        int index = value.indexOf(45) == 0 ? 1 : 0;
        char c0 = value.charAt(index);
        if (c0 == '0') {
            char c1 = value.charAt(index + 1);
            return c1 == 'x' || c1 == 'X';
        }
        return c0 == '#';
    }

    private static Boolean toBoolean(Number n) {
        Class<?> type = n.getClass();
        if (type == Double.class) {
            return n.doubleValue() != 0.0;
        }
        if (type == Float.class) {
            return n.floatValue() != 0.0f;
        }
        if (type == BigDecimal.class) {
            return ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0;
        }
        return n.intValue() != 0;
    }

    private static Boolean toBoolean(String str) {
        if (str == null) {
            return null;
        }
        switch (str.length()) {
            case 1: {
                char c = str.charAt(0);
                if (c == 'y' || c == 'Y' || c == 't' || c == 'T' || c == '1') {
                    return Boolean.TRUE;
                }
                if (c != 'n' && c != 'N' && c != 'f' && c != 'F' && c != '0') break;
                return Boolean.FALSE;
            }
            case 2: {
                if ("on".equalsIgnoreCase(str)) {
                    return Boolean.TRUE;
                }
                if (!"no".equalsIgnoreCase(str)) break;
                return Boolean.FALSE;
            }
            case 3: {
                if ("yes".equalsIgnoreCase(str)) {
                    return Boolean.TRUE;
                }
                if (!"off".equalsIgnoreCase(str)) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (!"true".equalsIgnoreCase(str)) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (!"false".equalsIgnoreCase(str)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static byte[] toBytes(Number n) {
        ByteBuffer buffer;
        if (n instanceof Long || n instanceof AtomicLong) {
            buffer = ByteBuffer.allocate(8);
            buffer.putLong(n.longValue());
        } else if (n instanceof Integer || n instanceof AtomicInteger) {
            buffer = ByteBuffer.allocate(4);
            buffer.putInt(n.intValue());
        } else if (n instanceof Double) {
            buffer = ByteBuffer.allocate(8);
            buffer.putDouble(n.doubleValue());
        } else if (n instanceof Float) {
            buffer = ByteBuffer.allocate(4);
            buffer.putFloat(n.floatValue());
        } else if (n instanceof Short) {
            buffer = ByteBuffer.allocate(2);
            buffer.putShort(n.shortValue());
        } else {
            if (n instanceof Byte) {
                return new byte[]{n.byteValue()};
            }
            if (n instanceof BigInteger) {
                return ((BigInteger)n).toByteArray();
            }
            return null;
        }
        return buffer.array();
    }

    private static ZonedDateTime toZonedDateTime(String str) {
        return DateUtils.parse(str).toInstant().atZone(ZoneId.systemDefault());
    }

    private static ZonedDateTime toZonedDateTime(Number num) {
        return Instant.ofEpochMilli(num.longValue()).atZone(ZoneId.systemDefault());
    }

    private static TimeZone toTimeZone(int offset) {
        if (offset < -12 || offset > 12) {
            throw new RestParameterException("Invalid timeZone offset " + offset);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("GMT");
        if (offset >= 0) {
            sb.append('+');
            if (offset < 10) {
                sb.append('0');
            }
        } else {
            sb.append('-');
            if (offset > -10) {
                sb.append('0');
            }
        }
        sb.append(offset).append(":00");
        return TimeZone.getTimeZone(sb.toString());
    }

    private static List toList(Iterable source) {
        ArrayList list = new ArrayList(32);
        for (Object item : source) {
            list.add(item);
        }
        return list;
    }

    private static List toList(Collection source) {
        if (source instanceof List) {
            return (List)source;
        }
        ArrayList list = new ArrayList(source.size());
        list.addAll(source);
        return list;
    }

    private static List arrayToList(Object source) {
        int len = Array.getLength(source);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = Array.get(source, i);
        }
        return Arrays.asList(array);
    }

    private static Collection toCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source.getClass().isArray()) {
            return GeneralTypeConverter.arrayToList(source);
        }
        if (source instanceof Iterable) {
            return GeneralTypeConverter.toList((Iterable)source);
        }
        if (source instanceof CharSequence) {
            return StringUtils.tokenizeToList(source.toString(), new char[0]);
        }
        return Collections.singletonList(source);
    }
}

