/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h3.negotiation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleConstants;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.transport.H2TransportListener;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleHttp2ClientResponseHandler;

public class NegotiateClientCall {
    private final AbstractConnectionClient connectionClient;
    private final Executor executor;

    public NegotiateClientCall(AbstractConnectionClient connectionClient, Executor executor) {
        this.connectionClient = connectionClient;
        this.executor = executor;
    }

    public CompletableFuture<String> start(URL url) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            Channel channel = (Channel)this.connectionClient.getChannel(true);
            Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap(channel);
            bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) {
                    ctx.channel().pipeline().addLast(new ChannelHandler[]{new ReadTimeoutHandler(12L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new TripleHttp2ClientResponseHandler(new Listener(NegotiateClientCall.this.executor, future))});
                }
            });
            Future streamFuture = bootstrap.open();
            streamFuture.addListener(f -> {
                if (f.isSuccess()) {
                    ((Http2StreamChannel)streamFuture.getNow()).writeAndFlush((Object)this.buildHeaders(url)).addListener(cf -> {
                        if (cf.isSuccess()) {
                            return;
                        }
                        future.completeExceptionally(cf.cause());
                    });
                    return;
                }
                future.completeExceptionally(f.cause());
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    private Http2HeadersFrame buildHeaders(URL url) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        boolean ssl = url.getParameter("ssl-enabled", false);
        AsciiString scheme = ssl ? TripleConstants.HTTPS_SCHEME : TripleConstants.HTTP_SCHEME;
        headers.scheme((CharSequence)scheme).authority((CharSequence)url.getAddress()).method((CharSequence)HttpMethod.OPTIONS.asciiName()).path((CharSequence)"/").set((Object)TripleHeaderEnum.SERVICE_TIMEOUT.name(), (Object)"10000");
        return new DefaultHttp2HeadersFrame((Http2Headers)headers, true);
    }

    private static final class Listener
    implements H2TransportListener {
        private final Executor executor;
        private final CompletableFuture<String> future;

        Listener(Executor executor, CompletableFuture<String> future) {
            this.executor = executor;
            this.future = future;
        }

        @Override
        public void onHeader(Http2Headers headers, boolean endStream) {
            HttpResponseStatus status;
            if (endStream) {
                return;
            }
            CharSequence line = headers.status();
            if (line != null && (status = HttpResponseStatus.parseLine((CharSequence)line)).code() < 500) {
                CharSequence altSvc = (CharSequence)headers.get((Object)HttpHeaderNames.ALT_SVC.getKey());
                this.executor.execute(() -> this.future.complete(String.valueOf(altSvc)));
                return;
            }
            this.executor.execute(() -> this.future.completeExceptionally(new RuntimeException("Status: " + line)));
        }

        @Override
        public void onData(ByteBuf data, boolean endStream) {
        }

        @Override
        public void cancelByRemote(long errorCode) {
            this.executor.execute(() -> this.future.completeExceptionally(new RuntimeException("Canceled by remote")));
        }

        @Override
        public void onClose() {
            if (this.future.isDone()) {
                return;
            }
            this.cancelByRemote(TriRpcStatus.CANCELLED.code.code);
        }
    }
}

