/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.ExceptionHandler;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class CompositeExceptionHandler
implements ExceptionHandler<Throwable, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeExceptionHandler.class);
    private final List<ExceptionHandler> exceptionHandlers;
    private final Map<Class, List<ExceptionHandler>> cache = CollectionUtils.newConcurrentHashMap();

    public CompositeExceptionHandler(FrameworkModel frameworkModel) {
        this.exceptionHandlers = frameworkModel.getActivateExtensions(ExceptionHandler.class);
    }

    @Override
    public Level resolveLogLevel(Throwable throwable) {
        List<ExceptionHandler> exceptionHandlers = this.getSuitableExceptionHandlers(throwable.getClass());
        int size = exceptionHandlers.size();
        for (int i = 0; i < size; ++i) {
            Level level = exceptionHandlers.get(i).resolveLogLevel(throwable);
            if (level == null) continue;
            return level;
        }
        if (throwable instanceof HttpStatusException) {
            int httpStatusCode = ((HttpStatusException)throwable).getStatusCode();
            if (httpStatusCode < HttpStatus.BAD_REQUEST.getCode()) {
                return TripleProtocol.VERBOSE_ENABLED ? Level.INFO : Level.DEBUG;
            }
            if (httpStatusCode < HttpStatus.INTERNAL_SERVER_ERROR.getCode()) {
                return Level.INFO;
            }
        }
        return Level.ERROR;
    }

    @Override
    public boolean resolveGrpcStatus(Throwable throwable, HttpHeaders headers, RequestMetadata metadata, MethodDescriptor descriptor) {
        throwable = ExceptionUtils.unwrap(throwable);
        List<ExceptionHandler> exceptionHandlers = this.getSuitableExceptionHandlers(throwable.getClass());
        int size = exceptionHandlers.size();
        for (int i = 0; i < size; ++i) {
            if (!exceptionHandlers.get(i).resolveGrpcStatus(throwable, headers, metadata, descriptor)) continue;
            return true;
        }
        TriRpcStatus status = TriRpcStatus.getStatus(throwable);
        headers.set((CharSequence)GrpcHeaderNames.GRPC_STATUS.getName(), String.valueOf(status.code.code));
        headers.set((CharSequence)GrpcHeaderNames.GRPC_MESSAGE.getName(), TripleProtocol.VERBOSE_ENABLED ? ExceptionUtils.buildVerboseMessage(throwable) : throwable.getMessage());
        return true;
    }

    @Override
    public Object handle(Throwable throwable, RequestMetadata metadata, MethodDescriptor descriptor) {
        throwable = ExceptionUtils.unwrap(throwable);
        List<ExceptionHandler> exceptionHandlers = this.getSuitableExceptionHandlers(throwable.getClass());
        int size = exceptionHandlers.size();
        for (int i = 0; i < size; ++i) {
            Object result = exceptionHandlers.get(i).handle(throwable, metadata, descriptor);
            if (result == null) continue;
            return result;
        }
        int statusCode = -1;
        int grpcStatusCode = -1;
        if (throwable instanceof HttpStatusException) {
            statusCode = ((HttpStatusException)throwable).getStatusCode();
        } else {
            grpcStatusCode = TriRpcStatus.grpcCodeToHttpStatus(TriRpcStatus.getStatus((Throwable)throwable).code);
        }
        if (TripleProtocol.VERBOSE_ENABLED) {
            if (statusCode == -1) {
                statusCode = grpcStatusCode < 0 ? HttpStatus.INTERNAL_SERVER_ERROR.getCode() : grpcStatusCode;
            }
            LOGGER.info("Http request process error: status={}", statusCode, throwable);
        }
        return grpcStatusCode < 0 ? null : new HttpStatusException(grpcStatusCode, throwable.getMessage(), throwable);
    }

    @Override
    public Object handleGrpc(Throwable throwable, RequestMetadata metadata, MethodDescriptor descriptor) {
        Method method;
        throwable = ExceptionUtils.unwrap(throwable);
        List<ExceptionHandler> exceptionHandlers = this.getSuitableExceptionHandlers(throwable.getClass());
        int size = exceptionHandlers.size();
        for (int i = 0; i < size; ++i) {
            Object result = exceptionHandlers.get(i).handleGrpc(throwable, metadata, descriptor);
            if (result == null) continue;
            return result;
        }
        if (descriptor != null && (method = descriptor.getMethod()) != null) {
            for (Class<?> exceptionClass : method.getExceptionTypes()) {
                if (!exceptionClass.isInstance(throwable)) continue;
                return HttpResult.of(throwable);
            }
        }
        if (TripleProtocol.VERBOSE_ENABLED) {
            LOGGER.info("Grpc http request process error", throwable);
        }
        return null;
    }

    private List<ExceptionHandler> getSuitableExceptionHandlers(Class type) {
        return this.cache.computeIfAbsent(type, k -> {
            ArrayList<ExceptionHandler> result = new ArrayList<ExceptionHandler>();
            for (ExceptionHandler handler : this.exceptionHandlers) {
                Class<?> supportType = TypeUtils.getSuperGenericType(handler.getClass());
                if (supportType == null || !supportType.isAssignableFrom(type)) continue;
                result.add(handler);
            }
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            LOGGER.info("Found suitable ExceptionHandler for [{}], handlers: {}", type, result);
            return result;
        });
    }
}

