/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.net.InetSocketAddress;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.http12.exception.HttpRequestTimeout;
import org.apache.dubbo.remoting.http12.h2.Http2CancelableStreamObserver;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.h12.AttachmentHolder;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallListener;

public abstract class AbstractServerCallListener
implements ServerCallListener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractServerCallListener.class);
    protected final RpcInvocation invocation;
    protected final Invoker<?> invoker;
    protected final StreamObserver<Object> responseObserver;

    public AbstractServerCallListener(RpcInvocation invocation, Invoker<?> invoker, StreamObserver<Object> responseObserver) {
        this.invocation = invocation;
        this.invoker = invoker;
        this.responseObserver = responseObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        if (this.responseObserver instanceof Http2CancelableStreamObserver) {
            RpcContext.restoreCancellationContext(((Http2CancelableStreamObserver)this.responseObserver).getCancellationContext());
        }
        InetSocketAddress remoteAddress = (InetSocketAddress)this.invocation.getAttributes().remove("tri.remote.address");
        RpcContext.getServiceContext().setRemoteAddress(remoteAddress);
        String remoteApp = (String)this.invocation.getAttributes().remove((Object)TripleHeaderEnum.CONSUMER_APP_NAME_KEY);
        if (remoteApp != null) {
            RpcContext.getServiceContext().setRemoteApplicationName(remoteApp);
            this.invocation.setAttachmentIfAbsent("remote.application", remoteApp);
        }
        try {
            long stInMillis = System.currentTimeMillis();
            Result response = this.invoker.invoke(this.invocation);
            if (response.hasException()) {
                this.responseObserver.onError(response.getException());
                return;
            }
            response.whenCompleteWithContext((r, t) -> {
                if (this.responseObserver instanceof AttachmentHolder) {
                    ((AttachmentHolder)((Object)this.responseObserver)).setResponseAttachments(response.getObjectAttachments());
                }
                if (t != null) {
                    this.responseObserver.onError((Throwable)t);
                    return;
                }
                if (r.hasException()) {
                    this.responseObserver.onError(r.getException());
                    return;
                }
                long cost = System.currentTimeMillis() - stInMillis;
                Long timeout = (Long)this.invocation.get("timeout");
                if (timeout != null && timeout < cost) {
                    LOGGER.error("4-13", "", "", String.format("Invoke timeout at server side, ignored to send response. service=%s method=%s cost=%s", this.invocation.getTargetServiceUniqueName(), this.invocation.getMethodName(), cost));
                    HttpRequestTimeout serverSideTimeout = HttpRequestTimeout.serverSide();
                    this.responseObserver.onError(serverSideTimeout);
                    return;
                }
                this.onReturn(r.getValue());
            });
        }
        catch (Exception e) {
            this.responseObserver.onError(e);
        }
        finally {
            RpcContext.removeCancellationContext();
            RpcContext.removeContext();
        }
    }

    public abstract void onReturn(Object var1);
}

