/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.serialize.SerializationException;
import org.apache.dubbo.common.utils.AtomicPositiveInteger;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.ClientsProvider;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DubboInvoker<T>
extends AbstractInvoker<T> {
    private final ClientsProvider clientsProvider;
    private final AtomicPositiveInteger index = new AtomicPositiveInteger();
    private final ReentrantLock destroyLock = new ReentrantLock();
    private final Set<Invoker<?>> invokers;
    private final int serverShutdownTimeout;
    private static final boolean setFutureWhenSync = Boolean.parseBoolean(SystemPropertyConfigUtils.getSystemProperty("future.sync.set", "true"));

    public DubboInvoker(Class<T> serviceType, URL url, ClientsProvider clientsProvider) {
        this(serviceType, url, clientsProvider, null);
    }

    public DubboInvoker(Class<T> serviceType, URL url, ClientsProvider clientsProvider, Set<Invoker<?>> invokers) {
        super(serviceType, url, new String[]{"interface", "group", "token"});
        this.clientsProvider = clientsProvider;
        this.invokers = invokers;
        this.serverShutdownTimeout = ConfigurationUtils.getServerShutdownTimeout(this.getUrl().getScopeModel());
    }

    @Override
    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        String methodName = RpcUtils.getMethodName(invocation);
        inv.setAttachment("path", this.getUrl().getPath());
        inv.setAttachment("version", this.version);
        List<? extends ExchangeClient> exchangeClients = this.clientsProvider.getClients();
        ExchangeClient currentClient = exchangeClients.size() == 1 ? exchangeClients.get(0) : exchangeClients.get(this.index.getAndIncrement() % exchangeClients.size());
        RpcContext.getServiceContext().setLocalAddress(currentClient.getLocalAddress());
        try {
            boolean isOneway = RpcUtils.isOneway(this.getUrl(), invocation);
            int timeout = RpcUtils.calculateTimeout(this.getUrl(), invocation, methodName, 1000L);
            if (timeout <= 0) {
                return AsyncRpcResult.newDefaultAsyncResult(new RpcException(8, "No time left for making the following call: " + invocation.getServiceName() + "." + RpcUtils.getMethodName(invocation) + ", terminate directly."), invocation);
            }
            invocation.setAttachment("timeout", String.valueOf(timeout));
            Integer payload = this.getUrl().getParameter("payload", Integer.class);
            Request request = new Request();
            if (payload != null) {
                request.setPayload(payload);
            }
            request.setData(inv);
            request.setVersion(Version.getProtocolVersion());
            if (isOneway) {
                boolean isSent = this.getUrl().getMethodParameter(methodName, "sent", false);
                request.setTwoWay(false);
                currentClient.send(request, isSent);
                return AsyncRpcResult.newDefaultAsyncResult(invocation);
            }
            request.setTwoWay(true);
            ExecutorService executor = this.getCallbackExecutor(this.getUrl(), inv);
            CompletionStage appResponseFuture = currentClient.request(request, timeout, executor).thenApply(AppResponse.class::cast);
            if (setFutureWhenSync || ((RpcInvocation)invocation).getInvokeMode() != InvokeMode.SYNC) {
                FutureContext.getContext().setCompatibleFuture((CompletableFuture<?>)appResponseFuture);
            }
            AsyncRpcResult result = new AsyncRpcResult((CompletableFuture<AppResponse>)appResponseFuture, inv);
            result.setExecutor(executor);
            return result;
        }
        catch (TimeoutException e) {
            throw new RpcException(2, "Invoke remote method timeout. method: " + RpcUtils.getMethodName(invocation) + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
        catch (RemotingException e) {
            String remoteExpMsg = "Failed to invoke remote method: " + RpcUtils.getMethodName(invocation) + ", provider: " + this.getUrl() + ", cause: " + e.getMessage();
            if (e.getCause() instanceof IOException && e.getCause().getCause() instanceof SerializationException) {
                throw new RpcException(5, remoteExpMsg, e);
            }
            throw new RpcException(1, remoteExpMsg, e);
        }
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        for (ExchangeClient exchangeClient : this.clientsProvider.getClients()) {
            if (!exchangeClient.isConnected() || exchangeClient.hasAttribute("channel.readonly")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        if (!super.isDestroyed()) {
            this.destroyLock.lock();
            try {
                if (super.isDestroyed()) {
                    return;
                }
                super.destroy();
                if (this.invokers != null) {
                    this.invokers.remove(this);
                }
                this.clientsProvider.close(ConfigurationUtils.reCalShutdownTime(this.serverShutdownTimeout));
            }
            finally {
                this.destroyLock.unlock();
            }
        }
    }
}

