/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.registry.event.NettyEvent;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty4.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslServerTlsHandler;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class NettyServer
extends AbstractServer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyServer.class);
    private Map<String, Channel> channels;
    private ServerBootstrap bootstrap;
    private io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private final int serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout(this.getUrl().getOrDefaultModuleModel());

    public NettyServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap(handler, url));
    }

    @Override
    protected void doOpen() throws Throwable {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = this.createBossGroup();
        this.workerGroup = this.createWorkerGroup();
        NettyServerHandler nettyServerHandler = this.createNettyServerHandler();
        this.channels = nettyServerHandler.getChannels();
        this.initServerBootstrap(nettyServerHandler);
        try {
            ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)this.getBindAddress());
            channelFuture.syncUninterruptibly();
            this.channel = channelFuture.channel();
        }
        catch (Throwable t) {
            this.closeBootstrap();
            throw t;
        }
        if (this.isSupportMetrics()) {
            ApplicationModel applicationModel = ApplicationModel.defaultModel();
            MetricsEventBus.post(NettyEvent.toNettyEvent(applicationModel), () -> {
                HashMap<String, Long> dataMap = new HashMap<String, Long>();
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_HEAP_MEMORY_USED.getName(), PooledByteBufAllocator.DEFAULT.metric().usedHeapMemory());
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_DIRECT_MEMORY_USED.getName(), PooledByteBufAllocator.DEFAULT.metric().usedDirectMemory());
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_HEAP_ARENAS_NUM.getName(), Long.valueOf(PooledByteBufAllocator.DEFAULT.numHeapArenas()));
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_DIRECT_ARENAS_NUM.getName(), Long.valueOf(PooledByteBufAllocator.DEFAULT.numDirectArenas()));
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_NORMAL_CACHE_SIZE.getName(), Long.valueOf(PooledByteBufAllocator.DEFAULT.normalCacheSize()));
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_SMALL_CACHE_SIZE.getName(), Long.valueOf(PooledByteBufAllocator.DEFAULT.smallCacheSize()));
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_THREAD_LOCAL_CACHES_NUM.getName(), Long.valueOf(PooledByteBufAllocator.DEFAULT.numThreadLocalCaches()));
                dataMap.put(MetricsKey.NETTY_ALLOCATOR_CHUNK_SIZE.getName(), Long.valueOf(PooledByteBufAllocator.DEFAULT.chunkSize()));
                return dataMap;
            });
        }
    }

    private boolean isSupportMetrics() {
        return ClassUtils.isPresent("io.netty.buffer.PooledByteBufAllocatorMetric", NettyServer.class.getClassLoader());
    }

    protected EventLoopGroup createBossGroup() {
        return NettyEventLoopFactory.eventLoopGroup(1, "NettyServerBoss");
    }

    protected EventLoopGroup createWorkerGroup() {
        return NettyEventLoopFactory.eventLoopGroup(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), "NettyServerWorker");
    }

    protected NettyServerHandler createNettyServerHandler() {
        return new NettyServerHandler(this.getUrl(), this);
    }

    protected void initServerBootstrap(final NettyServerHandler nettyServerHandler) {
        boolean keepalive = this.getUrl().getParameter("keep.alive", Boolean.FALSE);
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.SO_KEEPALIVE, (Object)keepalive).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                int closeTimeout = UrlUtils.getCloseTimeout(NettyServer.this.getUrl());
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyServer.this.getCodec(), NettyServer.this.getUrl(), NettyServer.this);
                ch.pipeline().addLast("negotiation", (io.netty.channel.ChannelHandler)new SslServerTlsHandler(NettyServer.this.getUrl()));
                ch.pipeline().addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("server-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler(0L, 0L, (long)closeTimeout, TimeUnit.MILLISECONDS)).addLast("handler", (io.netty.channel.ChannelHandler)nettyServerHandler);
            }
        });
    }

    @Override
    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        logger.warn("6-3", "", "", e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        this.closeBootstrap();
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    private void closeBootstrap() {
        try {
            if (this.bootstrap != null) {
                long timeout = ConfigurationUtils.reCalShutdownTime(this.serverShutdownTimeoutMills);
                long quietPeriod = Math.min(2000L, timeout);
                Future bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                Future workerGroupShutdownFuture = this.workerGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.syncUninterruptibly();
                workerGroupShutdownFuture.syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    @Override
    protected int getChannelsSize() {
        return this.channels.size();
    }

    @Override
    public Collection<Channel> getChannels() {
        return new ArrayList<Channel>(this.channels.values());
    }

    @Override
    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString(remoteAddress));
    }

    @Override
    public boolean canHandleIdle() {
        return true;
    }

    @Override
    public boolean isBound() {
        return this.channel.isActive();
    }

    protected EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    protected EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    protected ServerBootstrap getServerBootstrap() {
        return this.bootstrap;
    }

    protected io.netty.channel.Channel getBossChannel() {
        return this.channel;
    }

    protected Map<String, Channel> getServerChannels() {
        return this.channels;
    }
}

