/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.api.connection.ConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.AddressUtils;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

@ChannelHandler.Sharable
public class NettyConnectionHandler
extends ChannelInboundHandlerAdapter
implements ConnectionHandler {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(NettyConnectionHandler.class);
    private static final AttributeKey<Boolean> GO_AWAY_KEY = AttributeKey.valueOf((String)"dubbo_channel_goaway");
    private final AbstractNettyConnectionClient connectionClient;

    public NettyConnectionHandler(AbstractNettyConnectionClient connectionClient) {
        this.connectionClient = connectionClient;
    }

    @Override
    public void onGoAway(Object channel) {
        if (!(channel instanceof Channel)) {
            return;
        }
        Channel nettyChannel = (Channel)channel;
        Attribute attr = nettyChannel.attr(GO_AWAY_KEY);
        if (Boolean.TRUE.equals(attr.get())) {
            return;
        }
        attr.set((Object)true);
        if (this.connectionClient != null) {
            this.connectionClient.onGoaway(nettyChannel);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Channel %s go away ,schedule reconnect", nettyChannel));
        }
        this.reconnect(nettyChannel);
    }

    @Override
    public void reconnect(Object channel) {
        if (!(channel instanceof Channel)) {
            return;
        }
        Channel nettyChannel = (Channel)channel;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Connection %s is reconnecting, attempt=%d", this.connectionClient, 1));
        }
        EventLoop eventLoop = nettyChannel.eventLoop();
        if (this.connectionClient.isClosed()) {
            LOGGER.info("The client has been closed and will not reconnect. ");
            return;
        }
        eventLoop.schedule(() -> {
            try {
                this.connectionClient.doConnect();
            }
            catch (Throwable e) {
                LOGGER.error("6-16", "", "", "Fail to connect to " + this.connectionClient.getChannel(), e);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
        Channel ch = ctx.channel();
        NettyChannel.getOrAddChannel(ch, this.connectionClient.getUrl(), this.connectionClient);
        if (!this.connectionClient.isClosed()) {
            this.connectionClient.onConnected(ch);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The connection {} of {} -> {} is established.", ch, AddressUtils.getLocalAddressKey(ch), AddressUtils.getRemoteAddressKey(ch));
            }
        } else {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Channel ch = ctx.channel();
        try {
            Attribute goawayAttr = ch.attr(GO_AWAY_KEY);
            if (!Boolean.TRUE.equals(goawayAttr.get())) {
                this.reconnect(ch);
            }
            LOGGER.info("The connection {} of {} -> {} is disconnected.", ch, AddressUtils.getLocalAddressKey(ch), AddressUtils.getRemoteAddressKey(ch));
        }
        finally {
            NettyChannel.removeChannel(ch);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("6-4", "", "", String.format("Channel error:%s", ctx.channel()), cause);
        ctx.close();
    }
}

