/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyConfigOperator;
import org.apache.dubbo.remoting.transport.netty4.NettyConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettySslContextOperator;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslClientTlsHandler;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;
import org.apache.dubbo.remoting.utils.UrlUtils;

public final class NettyConnectionClient
extends AbstractNettyConnectionClient {
    private Bootstrap bootstrap;

    public NettyConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void initConnectionClient() {
        this.protocol = this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class).getExtension(this.getUrl().getProtocol());
        super.initConnectionClient();
    }

    @Override
    protected void initBootstrap() {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP.get())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).remoteAddress((SocketAddress)this.getConnectAddress()).channel(NettyEventLoopFactory.socketChannelClass());
        final NettyConnectionHandler connectionHandler = new NettyConnectionHandler(this);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getConnectTimeout());
        final SslContext sslContext = SslContexts.buildClientSslContext(this.getUrl());
        bootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                NettyChannel nettyChannel = NettyChannel.getOrAddChannel((Channel)ch, NettyConnectionClient.this.getUrl(), NettyConnectionClient.this.getChannelHandler());
                ChannelPipeline pipeline = ch.pipeline();
                NettySslContextOperator nettySslContextOperator = new NettySslContextOperator();
                if (sslContext != null) {
                    pipeline.addLast("negotiation", (io.netty.channel.ChannelHandler)new SslClientTlsHandler(sslContext));
                }
                int heartbeat = UrlUtils.getHeartbeat(NettyConnectionClient.this.getUrl());
                pipeline.addLast("client-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler((long)heartbeat, 0L, 0L, TimeUnit.MILLISECONDS));
                pipeline.addLast("connectionHandler", (io.netty.channel.ChannelHandler)connectionHandler);
                NettyConfigOperator operator = new NettyConfigOperator(nettyChannel, NettyConnectionClient.this.getChannelHandler());
                NettyConnectionClient.this.protocol.configClientPipeline(NettyConnectionClient.this.getUrl(), operator, nettySslContextOperator);
                ch.closeFuture().addListener(channelFuture -> NettyConnectionClient.this.clearNettyChannel());
            }
        });
        this.bootstrap = bootstrap;
    }

    @Override
    protected ChannelFuture performConnect() {
        return this.bootstrap.connect();
    }
}

