/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Endpoint;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

public abstract class AbstractNettyConnectionClient
extends AbstractConnectionClient {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractNettyConnectionClient.class);
    private AtomicReference<Promise<Object>> connectingPromiseRef;
    private AtomicReference<io.netty.channel.Channel> channelRef;
    private Promise<Void> connectedPromise;
    private Promise<Void> disconnectedPromise;
    private Promise<Void> closePromise;
    private AtomicBoolean isReconnecting;
    private ConnectionListener connectionListener;
    public static final AttributeKey<AbstractConnectionClient> CONNECTION = AttributeKey.valueOf((String)"connection");

    public AbstractNettyConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void doOpen() throws Throwable {
        this.initConnectionClient();
        this.initBootstrap();
    }

    @Override
    protected void initConnectionClient() {
        this.remote = this.getConnectAddress();
        this.init = new AtomicBoolean(false);
        this.connectingPromiseRef = new AtomicReference();
        this.channelRef = new AtomicReference();
        this.connectedPromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.disconnectedPromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.closePromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.isReconnecting = new AtomicBoolean(false);
        this.connectionListener = new ConnectionListener();
        this.increase();
    }

    protected abstract void initBootstrap() throws Exception;

    @Override
    protected void doClose() {
        if (this.isClosed()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Connection:%s freed ", this));
            }
            this.performClose();
            this.closePromise.setSuccess(null);
        }
    }

    protected void performClose() {
        io.netty.channel.Channel current = this.getNettyChannel();
        if (current != null) {
            current.close();
        }
        this.clearNettyChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws RemotingException {
        if (!this.isReconnecting.compareAndSet(false, true)) {
            return;
        }
        if (this.isClosed() && LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s aborted to reconnect cause connection closed. ", this));
        }
        this.init.compareAndSet(false, true);
        long start = System.currentTimeMillis();
        Promise<Object> connectingPromise = this.getOrCreateConnectingPromise();
        ChannelFuture connectPromise = this.performConnect();
        connectPromise.addListener((GenericFutureListener)this.connectionListener);
        boolean ret = connectingPromise.awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        AbstractNettyConnectionClient abstractNettyConnectionClient = this;
        synchronized (abstractNettyConnectionClient) {
            this.connectingPromiseRef.set(null);
        }
        if (connectPromise.cause() != null) {
            Throwable cause = connectPromise.cause();
            RemotingException remotingException = new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + ", error message is:" + cause.getMessage(), cause);
            LOGGER.error("6-1", "network disconnected", "", "Failed to connect to provider server by other reason.", cause);
            throw remotingException;
        }
        if (!ret || !connectPromise.isSuccess()) {
            RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            LOGGER.error("6-2", "provider crash", "", "Client-side timeout.", remotingException);
            throw remotingException;
        }
    }

    protected abstract ChannelFuture performConnect();

    @Override
    protected void doDisConnect() {
        NettyChannel.removeChannelIfDisconnected(this.getNettyChannel());
    }

    @Override
    public void onConnected(Object channel) {
        if (!(channel instanceof io.netty.channel.Channel)) {
            return;
        }
        io.netty.channel.Channel nettyChannel = (io.netty.channel.Channel)channel;
        if (this.isClosed()) {
            nettyChannel.close();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s is closed, ignoring connected event", this));
            }
            return;
        }
        io.netty.channel.Channel current = this.getNettyChannel();
        if (current != null) {
            current.close();
        }
        this.channelRef.set(nettyChannel);
        Promise<Object> connectingPromise = this.connectingPromiseRef.get();
        if (connectingPromise != null) {
            connectingPromise.trySuccess(CONNECTED_OBJECT);
        }
        nettyChannel.attr(CONNECTION).set((Object)this);
        this.connectedPromise.trySuccess(null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s connected ", this));
        }
    }

    @Override
    public void onGoaway(Object channel) {
        if (!(channel instanceof io.netty.channel.Channel)) {
            return;
        }
        io.netty.channel.Channel nettyChannel = (io.netty.channel.Channel)channel;
        if (this.channelRef.compareAndSet(nettyChannel, null)) {
            if (nettyChannel.isOpen()) {
                nettyChannel.close();
            }
            NettyChannel.removeChannelIfDisconnected(nettyChannel);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s goaway", this));
            }
        }
    }

    @Override
    protected Channel getChannel() {
        io.netty.channel.Channel c = this.getNettyChannel();
        if (c == null) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), this);
    }

    private io.netty.channel.Channel getNettyChannel() {
        return this.channelRef.get();
    }

    protected void clearNettyChannel() {
        this.channelRef.set(null);
    }

    @Override
    public <T> T getChannel(Boolean generalizable) {
        return (T)(Boolean.TRUE.equals(generalizable) ? this.getNettyChannel() : this.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        if (this.isClosed()) {
            return false;
        }
        io.netty.channel.Channel nettyChannel = this.getNettyChannel();
        if (nettyChannel != null && nettyChannel.isActive()) {
            return true;
        }
        if (this.init.compareAndSet(false, true)) {
            try {
                this.doConnect();
            }
            catch (RemotingException e) {
                LOGGER.error("6-16", "", "", "Failed to connect to server: " + this.getConnectAddress());
            }
        }
        this.getOrCreateConnectingPromise().awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        AbstractNettyConnectionClient abstractNettyConnectionClient = this;
        synchronized (abstractNettyConnectionClient) {
            this.connectingPromiseRef.set(null);
        }
        nettyChannel = this.getNettyChannel();
        return nettyChannel != null && nettyChannel.isActive();
    }

    private Promise<Object> getOrCreateConnectingPromise() {
        this.connectingPromiseRef.compareAndSet(null, (Promise<Object>)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE));
        return this.connectingPromiseRef.get();
    }

    public Promise<Void> getClosePromise() {
        return this.closePromise;
    }

    public static AbstractConnectionClient getConnectionClientFromChannel(io.netty.channel.Channel channel) {
        return (AbstractConnectionClient)channel.attr(CONNECTION).get();
    }

    public ChannelFuture write(Object request) throws RemotingException {
        if (!this.isAvailable()) {
            throw new RemotingException(null, null, "Failed to send request " + request + ", cause: The channel to " + this.remote + " is closed!");
        }
        return this.getNettyChannel().writeAndFlush(request);
    }

    @Override
    public void addConnectedListener(Runnable func) {
        this.connectedPromise.addListener(future -> func.run());
    }

    @Override
    public void addDisconnectedListener(Runnable func) {
        this.disconnectedPromise.addListener(future -> func.run());
    }

    @Override
    public void addCloseListener(Runnable func) {
        this.closePromise.addListener(future -> func.run());
    }

    @Override
    public void destroy() {
        this.close();
    }

    @Override
    public String toString() {
        return super.toString() + " (Ref=" + this.getCounter() + ",local=" + Optional.ofNullable(this.getChannel()).map(Endpoint::getLocalAddress).orElse(null) + ",remote=" + this.getRemoteAddress();
    }

    class ConnectionListener
    implements ChannelFutureListener {
        ConnectionListener() {
        }

        public void operationComplete(ChannelFuture future) {
            if (!AbstractNettyConnectionClient.this.isReconnecting.compareAndSet(true, false)) {
                return;
            }
            if (future.isSuccess()) {
                return;
            }
            AbstractNettyConnectionClient connectionClient = AbstractNettyConnectionClient.this;
            if (connectionClient.isClosed() || connectionClient.getCounter() == 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s aborted to reconnect. %s", connectionClient, future.cause().getMessage()));
                }
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s is reconnecting, attempt=%d cause=%s", connectionClient, 0, future.cause().getMessage()));
            }
            AbstractNettyConnectionClient.this.disconnectedPromise.trySuccess(null);
            AbstractNettyConnectionClient.this.connectivityExecutor.schedule(() -> {
                try {
                    connectionClient.doConnect();
                }
                catch (RemotingException e) {
                    LOGGER.error("6-16", "", "", "Failed to connect to server: " + AbstractNettyConnectionClient.this.getConnectAddress());
                }
            }, AbstractNettyConnectionClient.this.reconnectDuration, TimeUnit.MILLISECONDS);
        }
    }
}

