/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.dispatcher;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.InternalThreadLocalMap;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;

public class ChannelEventRunnable
implements Runnable {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ChannelEventRunnable.class);
    private final ChannelHandler handler;
    private final Channel channel;
    private final ChannelState state;
    private final Throwable exception;
    private final Object message;

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state) {
        this(channel, handler, state, null);
    }

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state, Object message) {
        this(channel, handler, state, message, null);
    }

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state, Throwable t) {
        this(channel, handler, state, null, t);
    }

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state, Object message, Throwable exception) {
        this.channel = channel;
        this.handler = handler;
        this.state = state;
        this.message = message;
        this.exception = exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.getAndRemove();
        try {
            if (this.state == ChannelState.RECEIVED) {
                try {
                    this.handler.received(this.channel, this.message);
                    return;
                }
                catch (Exception e) {
                    logger.warn("99-0", "unknown error in remoting module", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel + ", message is " + this.message, e);
                }
                return;
            }
            switch (this.state.ordinal()) {
                case 0: {
                    try {
                        this.handler.connected(this.channel);
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("99-0", "unknown error in remoting module", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel, e);
                        return;
                    }
                }
                case 1: {
                    try {
                        this.handler.disconnected(this.channel);
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("99-0", "unknown error in remoting module", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel, e);
                        return;
                    }
                }
                case 2: {
                    try {
                        this.handler.sent(this.channel, this.message);
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("99-0", "unknown error in remoting module", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel + ", message is " + this.message, e);
                        return;
                    }
                }
                case 4: {
                    try {
                        this.handler.caught(this.channel, this.exception);
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("99-0", "unknown error in remoting module", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel + ", message is: " + this.message + ", exception is " + this.exception, e);
                        return;
                    }
                }
                default: {
                    logger.warn("99-0", "unknown error in remoting module", "", "unknown state: " + (Object)((Object)this.state) + ", message is " + this.message);
                    return;
                }
            }
        }
        finally {
            InternalThreadLocalMap.set(internalThreadLocalMap);
        }
    }

    public static enum ChannelState {
        CONNECTED,
        DISCONNECTED,
        SENT,
        RECEIVED,
        CAUGHT;

    }
}

