/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.DateUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;

public class DefaultHttpResult<T>
implements HttpResult<T> {
    private static final long serialVersionUID = 1L;
    private int status;
    private Map<String, List<String>> headers;
    private T body;

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public String toString() {
        return "DefaultHttpResult{status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + '}';
    }

    public static final class Builder<T> {
        private int status;
        private Map<String, List<String>> headers;
        private T body;

        public Builder<T> status(int status) {
            this.status = status;
            return this;
        }

        public Builder<T> status(HttpStatus status) {
            this.status = status.getCode();
            return this;
        }

        public Builder<T> ok() {
            return this.status(HttpStatus.OK.getCode());
        }

        public Builder<T> moved(String url) {
            return this.status(HttpStatus.MOVED_PERMANENTLY).header(HttpHeaderNames.LOCATION.getName(), url);
        }

        public Builder<T> found(String url) {
            return this.status(HttpStatus.FOUND).header(HttpHeaderNames.LOCATION.getName(), url);
        }

        public Builder<T> error() {
            return this.status(HttpStatus.INTERNAL_SERVER_ERROR);
        }

        public Builder<T> headers(Map<String, List<String>> headers) {
            if (headers == null || headers.isEmpty()) {
                return this;
            }
            Map<String, List<String>> hrs = this.headers;
            if (hrs == null) {
                this.headers = new LinkedHashMap<String, List<String>>(headers);
            } else {
                hrs.putAll(headers);
            }
            return this;
        }

        public Builder<T> headers(HttpHeaders headers) {
            if (headers == null || headers.isEmpty()) {
                return this;
            }
            Map<String, List<String>> hrs = this.headers;
            if (hrs == null) {
                hrs = new LinkedHashMap<String, List<String>>(headers.size());
            }
            for (Map.Entry<CharSequence, String> entry : headers) {
                CharSequence key = entry.getKey();
                if (HttpHeaderNames.SET_COOKIE.getKey().equals(key)) {
                    hrs.computeIfAbsent(key.toString(), k -> new ArrayList(1)).add(entry.getValue());
                    continue;
                }
                hrs.put(key.toString(), Collections.singletonList(entry.getValue()));
            }
            return this;
        }

        public Builder<T> header(String key, List<String> values) {
            this.headers().put(key, values);
            return this;
        }

        public Builder<T> header(String key, String ... values) {
            this.headers().put(key, Arrays.asList(values));
            return this;
        }

        public Builder<T> header(String key, String value) {
            this.headers().put(key, Collections.singletonList(value));
            return this;
        }

        public Builder<T> headerIf(String key, String value) {
            return StringUtils.isEmpty(value) ? this : this.header(key, value);
        }

        public Builder<T> header(String key, Date value) {
            return this.header(key, DateUtils.formatHeader(value));
        }

        public Builder<T> header(String key, Object value) {
            return this.header(key, String.valueOf(value));
        }

        public Builder<T> headerIf(String key, Object value) {
            return value == null ? this : this.header(key, value);
        }

        public Builder<T> addHeader(String key, String value) {
            this.headers().computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder<T> from(HttpResult<T> result) {
            this.status = result.getStatus();
            this.headers = result.getHeaders() == null ? null : new LinkedHashMap<String, List<String>>(result.getHeaders());
            this.body = result.getBody();
            return this;
        }

        private Map<String, List<String>> headers() {
            Map<String, List<String>> headers = this.headers;
            if (headers == null) {
                this.headers = headers = new LinkedHashMap<String, List<String>>();
            }
            return headers;
        }

        public Builder<T> body(T body) {
            this.body = body;
            return this;
        }

        public DefaultHttpResult<T> build() {
            DefaultHttpResult<T> result = new DefaultHttpResult<T>();
            result.setStatus(this.status);
            result.setHeaders(this.headers);
            result.setBody(this.body);
            return result;
        }
    }
}

